-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_controller = require 'controller.controller_object'
local c_storage_service = require 'storage.service'
local class = require 'mc.class'
local lu = require 'luaunit'
local sml = require 'sml'
local c_storageconfig = require 'storageconfig.storageconfig_object'

TestFaultCode = class(c_storage_service)

function TestFaultCode:test_update_ctrl_faultcode()
    local controller = {FaultCode = 0,
        Id = 0,
        TypeId = 20,
        update_controller_drives_policy = function()
        end,
        update_controller_battery_info = function()
        end
    }
    c_storageconfig.get_instance = function ()
        return {
            get_set_configuration_ready_flag = function()
            end
        }
    end
    local info = {ctrl_temp = 0,
        get_support_properties = function ()
            return {}
        end
    }
    local origin_func = sml.get_ctrl_faultcode
    sml.get_ctrl_faultcode = function()
        return {
            health_status_code = 0xfff,
            hw_err = 0,
            clk_err = 0,
            power_err = 0,
            capacity_err = 0,
            flash_err = 0,
            err_change = 0
        }
    end
    local ok = pcall(c_controller.update_controller_info, controller, info)
    lu.assertEquals(ok, true)
    lu.assertEquals(controller.FaultCode, 0xfff)
    sml.get_ctrl_faultcode = origin_func
end