local c_controller = require 'controller.controller_object'
local c_storage_service = require 'storage.service'
local class = require 'mc.class'
local lu = require 'luaunit'


TestEpdsupport = class(c_storage_service)

function TestEpdsupport:test_set_default_ctrl2_values()
    local controller = {CtrlOption2 = 32647}
    local info = {}
    local ok, _ = pcall(c_controller.set_default_ctrl2_values, controller, info)
    lu.assertEquals(ok, true)
    lu.assertEquals(controller.EpdSupported, false)
end

function TestEpdsupport:test_update_controller_drives_policy()
    local info = {ctrl_operations = {o_support_epd = 1},
        ld_operations = {
            o_support_read_policy = 1,
            o_support_write_policy = 1,
            o_support_io_policy = 1,
            o_support_access_policy = 1,
            o_support_disk_cache_policy = 1,
            o_default_write_policy = 1
        }
    }
    local controller = {}
    info.get_support_operations = function ()
        return info
    end
    local ok, _ = pcall(c_controller.update_controller_drives_policy, controller, info)
    lu.assertEquals(ok, true)
    lu.assertEquals(controller.EpdSupported, true)
    lu.assertEquals(controller.WritePolicyWritable, true)
    lu.assertEquals(controller.IOPolicyWritable, true)
    lu.assertEquals(controller.AccessPolicyWritable, true)
    lu.assertEquals(controller.ReadPolicyWritable, true)
    lu.assertEquals(controller.DriveCachePolicyWritable, true)
end

