-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local storage_setting = require 'storage_setting.storage_setting'
local lu = require 'luaunit'
local context = require 'mc.context'

TestStorageSetting = {}

function TestStorageSetting:test_init()
    local flag = false
    local obj = {
        connect_signal = function (obj, sign, cb)
            cb()
        end,
        register_property_changed_callback = function ()
            flag = true
        end
    }
    storage_setting.super.init = function()
    end
    context.get_context = function ()
    end
    storage_setting.ctor(obj)
    storage_setting.init(obj)
    storage_setting.log_operation_media_lifeleft_percent_threshold(obj, 5)
    lu.assertEquals(flag, true)
end