-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_controller = require "controller.controller_object"
local sml = require "sml"
local lu = require "luaunit"
local common_def = require "common_def"


TestCompatible = {}

function TestCompatible:test_trans()
    local ctrl = {Id = 1}

    -- 非法参数模拟调用失败
    local ok, _ = pcall(c_controller.trans_pd_vendor_data)
    lu.assertEquals(ok, false)
    sml.trans_drive_data = function (p1, p2)
        return true
    end
    -- 模拟调用成功
    ok, _ = pcall(c_controller.trans_pd_vendor_data, ctrl, ctrl.Id, '1')
    lu.assertEquals(ok, true)
end

function TestCompatible:test_type_id()
    -- 模拟没有映射关系
    local ctrl = {TypeId = 9999}
    local _, ret = pcall(c_controller.get_mapping_type_id, ctrl)
    lu.assertEquals(ret, 9999)

    -- 模拟存在映射关系
    common_def.TYPEID_MAPPING[9999] = 8888
    _, ret = pcall(c_controller.get_mapping_type_id, ctrl)
    lu.assertEquals(ret, 8888)

    -- 模拟本来就存在的Typeid，无需映射关系
    ctrl.TypeId = 1
    _, ret = pcall(c_controller.get_mapping_type_id, ctrl)
    lu.assertEquals(ret, 1)
end