-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


-- Create: 2022-9-14
local skynet = require 'skynet'
require 'skynet.manager'
local logging = require 'mc.logging'
local StorageApp = require 'storage_app'
require 'storage_mdb_object'

local function change_debuglog_path(option)
    if not option then
        return
    end
    logging:setLevel(logging.DEBUG)
    local old_info = logging.info
    logging.info = function(self, fmt, ...)
        skynet.error('INFO', string.format(fmt, ...))
        old_info(self, fmt, ...)
    end
    local old_error = logging.error
    logging.error = function(self, fmt, ...)
        skynet.error('ERROR', string.format(fmt, ...))
        old_error(self, fmt, ...)
    end
    local old_debug = logging.debug
    logging.debug = function(self, fmt, ...)
        skynet.error('DEBUG', string.format(fmt, ...))
        old_debug(self, fmt, ...)
    end
end

change_debuglog_path(false)

local CMD = {}

function CMD.exit()
    logging:info('storage service exit')
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.uniqueservice('storage/service/smld')
    skynet.register('.storage')
    StorageApp.new()
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)
