-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local method_misc = require 'method_misc'

---@class c_storage_setting: c_object

local c_storage_setting = c_object('StorageSetting')

function c_storage_setting:ctor()
end

function c_storage_setting:init()
    c_storage_setting.super.init(self)
    self:connect_signal(self.on_add_object_complete, function()
        self:register_property_changed_callback()
    end)
end


function c_storage_setting:log_operation_media_lifeleft_percent_threshold(value)
    log:operation(method_misc:get_op_initiator(), 'storage', 'Set SSD MediaLifeLeftPercentThreshold %s successfully', value)
end

local PROPERTY_CHANGED_FUNC = {
    ['SSDMediaLifeLeftPercentThreshold'] = c_storage_setting.log_operation_media_lifeleft_percent_threshold,
}

function c_storage_setting:register_property_changed_callback()
    self:connect_signal(self.on_property_changed, function(name, value)
        if PROPERTY_CHANGED_FUNC[name] then
            self:next_tick(PROPERTY_CHANGED_FUNC[name], self, value)
        end
    end)
end

return c_storage_setting
