-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local function BIT(x)
    return 1 << (x)
end

local ctrl_operation_cmd = {
    CTRL_OPERATION_DISABLE_COPYBACK      = 0,        -- 设置CopyBack是否禁止
    CTRL_OPERATION_ENABLE_SMART_COPYBACK = 1,        -- 设置是否使能SMART CopyBack功能
    CTRL_OPERATION_ENABLE_JBOD           = 2,        -- 设置是否使能JBOD功能
    CTRL_OPERATION_RESTORE_DEFAULT       = 3,        -- 控制器恢复默认设定值
    CTRL_OPERATION_SET_BIOS_BOOT_MODE    = 4,        -- 控制器BIOS启动模式，参考storelib枚举类型MR_BOOT_MODE
    CTRL_OPERATION_SET_PERSONALITY_MODE  = 5,        -- 设置raid卡的控制模式，当前有raid模式和jbod模式
    CTRL_OPERATION_SET_MAINTAIN_PDFAIL_HISTORY = 6,  -- 设置是否在重启过程中启用对故障PD的跟踪、是否对不在位的故障PD点灯
    CTRL_OPERATION_IMPORT_FOREIGN_CONFIG = 7,        -- 导入外部配置
    CTRL_OPERATION_DUMP_LOG              = 8,        -- 收集日志
    CTRL_OPERATION_ENABLE_NBWC           = 9,
    CTRL_OPERATION_READ_CACHE_POLICY     = 10,
    CTRL_OPERATION_WCP_VALUE             = 11,
    CTRL_OPERATION_ENABLE_CC             = 12,       -- 设置/开始/停止一致性校验功能
    CTRL_OPERATION_CLEAR_FOREIGN_CONFIG  = 13,       -- 清除外部配置

    BOOT_PRIORITY_NONE = 0,
    BOOT_PRIORITY_PRIMARY = 1,
    BOOT_PRIORITY_SECONDARY = 2,
    BOOT_PRIORITY_ALL = 3,
    BOOT_PRIORITY_INVALID = 0xFF,

    CTRL_CC_DISABLE = 0,
    CTRL_CC_ENABLE = 1,
    CTRL_CC_SET = 2,
    CTRL_CC_PERIOD_MIN = 24,                         -- 1天即24小时
    CTRL_CC_PERIOD_MAX = 1440,                       -- 60天即1440小时
    CTRL_CC_DELAY_MAX = 24,                          -- 最长为24小时
    CTRL_CC_MASK_PERIOD = BIT(0),
    CTRL_CC_MASK_RATE = BIT(1),
    CTRL_CC_MASK_REPAIR = BIT(2),
    CTRL_CC_MASK_DELAY = BIT(3),
    CTRL_CC_STR_LEN = 255,
    CTRL_CCHECK_RATE_LOW = 1,
    CTRL_CCHECK_RATE_MIDDLE = 2,
    CTRL_CCHECK_RATE_HIGH = 3,
}

return ctrl_operation_cmd