/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 *
 * this file licensed under the Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 *
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
 * PURPOSE.
 * See the Mulan PSL v2 for more details.
 *
 * Description: 华为自研的存储设备管理库(Storage Management Library)的基本信息
 */
#ifndef SML_BASE_H
#define SML_BASE_H

#include "platform.h"
#include "sml_controller.h"
#include "sml_logic_drive.h"
#include "sml_physical_drive.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define PD_ATTACHED_CONTROLLER_PCH     "PCH"
#define STORAGE_INFO_INVALID_STRING    "N/A"
#define STORAGE_INFO_INVALID_BYTE      0xFF
#define STORAGE_INFO_INVALID_WORD      0xFFFF
#define STORAGE_INFO_INVALID_DWORD     0xFFFFFFFF
#define STORAGE_INFO_UNSUPPORT_DWORD   0xFFFFFFFE
#define STORAGE_INFO_INVALID_QWORD     0xFFFFFFFFFFFFFFFF

typedef enum tag_oob_interface_type {
    OOB_TYPE_OVER_I2C = 0,
    OOB_TYPE_OVER_PCIE,
    OOB_TYPE_BUTT,
} OOB_INTERFACE_TYPE_E;

typedef gint32 (*I2C_WRITE_FUNC)(guint8 obj_index, guint8* pWritebuf, guint8 write_length);
typedef gint32 (*I2C_WRITEREAD_FUNC)(guint8 obj_index, guint8* pWritebuf, guint8 write_length,
    guint8* pReadbuf, guint8 read_length);
typedef gint32 (*MCTP_WRITEREAD_FUNC)(guint8 obj_index, guint32 request_length, const guint8 *request,
    guint32 *response_length, guint8 *response, guint32 timeout);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif

