/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SC_CTRL_H__
#define __SC_CTRL_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 pmc_add_ctrl(guint32 ctrl_id);
gint32 pmc_remove_ctrl(guint32 ctrl_id);
gint32 pmc_init_ctrl_manage(guint32 ctrl_id, MCTP_WRITEREAD_FUNC mctp_writeread_func);
gint32 pmc_exit_ctrl_manage(guint32 ctrl_id, MCTP_WRITEREAD_FUNC mctp_writeread_func);
gint32 pmc_update_ctrl_cache(guint32 ctrl_id);
gint32 pmc_get_ctrl_info(guint32 ctrl_id, gpointer data);
gint32 pmc_get_ctrl_sas_addr(guint32 ctrl_id, gpointer data);
gint32 pmc_get_ctrl_health(guint32 ctrl_id, gpointer data);
gint32 pmc_get_ctrl_bbu_status(guint32 ctrl_id, gpointer data);
gint32 pmc_get_ctrl_phy_err_count(guint32 ctrl_id, gpointer data);
gint32 pmc_ctrl_operations(guint32 ctrl_id, guint8 operation, gpointer param, guint32 param_length);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif