/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SL_PD_H__
#define __SL_PD_H__

#include "sml_public.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 lsi_get_pd_smart_info(guint32 ctrl_id, guint16 device_id, SML_PD_SAS_SMART_INFO *data);
gint32 lsi_get_pd_smart_info_spec(guint32 ctrl_id, guint16 device_id, SML_PD_SAS_SMART_INFO *data, guint8 filter);
gint32 GetSpareBlockPercent(SML_PD_INFO_S *pPDinfo);
gint32 GetEstimatedLifespanAndWriteAmpFactor(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pPDinfo);
gint32 GetSataDeviceTemperature(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pPDinfo);
gint32 GetRemMediaWearOutAndPowerOnHours(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pPDinfo);

typedef enum smart_info_mask_e {
    SMART_STRIP_TEMPERATURE = 0x01,
    SMART_READ_DEFECT_GLIST_LEN = 0x02,
    SMART_READ_DEFECT_PLIST_LEN = 0x04,
    SMART_MANUATURE_DATA = 0x08,
    SMART_BLOCK_SENT = 0x10,
    SMART_BLOCK_RECEIVED = 0x20,
    SMART_UNTIL_NEXT_INTER_SMART_TEST_MINUTES = 0x40
} smart_info_mask_t;

typedef gint32 (*SPECIFIED_SMART_INFO_PROCESS_FUN)(guint32 ctrl_id, guint16 device_id, SML_PD_SAS_SMART_INFO *data);
typedef struct tag_smart_info_processor {
    smart_info_mask_t mask;
    SPECIFIED_SMART_INFO_PROCESS_FUN process_func;
    char *log_info;
}SMART_INFO_PROCESSOR;

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
