/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SL_PD_H__
#define __SL_PD_H__

#include "sml_public.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 lsi_get_array_info(guint32 ctrl_id, guint16 array_ref, gpointer data);
gint32 lsi_get_pd_info(guint32 ctrl_id, guint16 device_id, gpointer data);
gint32 lsi_pd_operations(guint32 ctrl_id, guint16 device_id, guint8 operation, gpointer param, guint32 param_length);
gint32 lsi_diag_encl_comm_error(guint32 ctrl_id, guint16 pd_device_id, guint16 encl_device_id, guint8 is_encl_single,
    gpointer data);
gint32 lsi_diag_pd_sense_error(guint32 ctrl_id, guint16 pd_device_id, gchar *io_buf, gpointer data);
gint32 lsi_get_phy_diag_topo_info(guint32 ctrl_id, guint16 pd_device_id, gpointer data);
gint32 lsi_trans_drive_data(const char* json_raw_data);
#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
