/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SL_MISC_H__
#define __SL_MISC_H__

#include "sml_public.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 IsValidRaidLevelForSSCD(guint8 raid_level, guint8 num_drives, const SML_CREATE_LD_CTRL_INFO_S *pCtrlInfo);
gint32 IsValidRaidLevel(guint8 raid_level, guint8 num_drives, guint8 span_depth,
    const SML_CREATE_LD_CTRL_INFO_S *pCtrlInfo);
void remove_string_space(gchar *src, guint32 src_length);
void swapBytes(const void *src, void *dest, guint32 len);
gint32 check_duplicate_pd_id(const guint16 *id, const gsize id_count, const gsize id_max_count);
gint32 check_duplicate_ld_id(const guint8 *id, const gsize id_count, const gsize id_max_count);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
