/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SL_DIAGNOSE_H__
#define __SL_DIAGNOSE_H__

#include "lsi/storelib.h"
#include "sml_public.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

extern void InitCtrlDiagEvent(guint32 ctrl_id);
extern void RemoveCtrlDiagEvent(guint32 ctrl_id);
extern void ClearCtrlDiagEvent(guint32 ctrl_id);
extern void RecordCtrlDiagEvent(guint32 ctrl_id, MR_EVT_DETAIL *pEventDetail);
extern gint32 PraseTopoForPHYDaig(guint8 *topo_data, SML_CTRL_PHY_DIAG_TOPO_INFO_S *topo_info, guint16 pd_device_id);
extern gint32 DiagnoseEnclCommErr(guint32 ctrl_id, guint16 pd_device_id, guint16 encl_device_id, guint8 is_encl_single,
    guint32 *encl_comm_error_state);
extern gint32 DiagnosePDSenseError(guint32 ctrl_id, guint16 pd_device_id, gchar *io_buf,
    guint32 *sense_error_state);
extern gint32 MockInsertCtrlEvent(guint32 ctrl_id, SML_MOCK_CTRL_EVENT_S *mock_event);
extern guint8 CheckPDSenseCode(SCSI_SENSE_DISECT_S *sense_info, const gchar *vendor_name);
extern guint8 CheckPHYIsVirtual(SL_TOPOLOGY_END_DEVICE_NODE_T *end_node);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
