/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SL_H__
#define __SL_H__

#include "sml_public.h"
#include "sml_common.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

typedef union _tag_sas_addr64 {
    struct {
        guint32 addr32Low;
        guint32 addr32High;
    } u;
    guint8 addrByte[8];
    guint64 addr64;
} SML_SAS_ADDR_64;

typedef struct _tag_scsi_inquiry_data {
    gchar vendorID[8];
    gchar productID[16];
    gchar productRevLevel[4];
    gchar info[32];
} SCSI_INQUIRY_DATA_S;

typedef enum _tag_scsi_inquiry_data_type {
    SCSI_INQUIRY_DATA_MANUFACTURER,
    SCSI_INQUIRY_DATA_SN,
    SCSI_INQUIRY_DATA_MODEL,
    SCSI_INQUIRY_DATA_FW_VERSION,
} SCSI_INQUIRY_DATA_TYPE_E;

typedef struct _tag_slt_aen_info {
    gint32 valid;
    SL_REG_AEN_OUTPUT_T regAenOutput;
    MR_EVT_CLASS_LOCALE eventMask[SL_MAX_CONTROLLERS];
} SLT_AEN_INFO_S;

typedef struct _tag_raid_level_info {
    guint8 raid_level;
    guint8 span_depth;
    guint8 num_drive_per_span;
} SLT_RAID_LEVEL_INFO_S;

typedef struct _tag_topo_list_element {
    guint64 sasAddr;
    guint8 numPhy;
    guint8 numVirtualPhy;
    guint8 deviceType;
    SL_TOPOLOGY_DEVICE_BITMAP devBitMap;
} SL_LIST_ELEMENT_T;

typedef struct _tag_smp_buffer_page {
    void *requestPage;
    void *responsePage;
    guint32 requestLength;
    guint32 responseLength;
} SL_SMP_BUFFER_PAGE;

#define INVALID_CTRL_ID 0xFFFFFFFF
#define CHECK_BOOT_INFO_START_ADDR 446
#define BOOT_RECORD_LEN 16
#define BOOT_INFO_FLAG 128

#define DEFAULT_STRIP_SIZE 7

#define INVALID_CONTROLLER_TEMP_VALUE 255

#define PD_EID_NOT_IN_ENCLOSURE 0xFFFF
#define PD_EID_CONVERT_RETRY_MAX 10

#define  SL_LIB_TYPE_STORELIBCUSTOM 6

#define BLK2GB(blk, UserDataBlockSize) (((blk) * (UserDataBlockSize)) / (1024 * 1024 * 1024))
#define BLK2MB(blk, UserDataBlockSize) (((blk) * (UserDataBlockSize)) / (1024 * 1024))
#define BLK2MB_PLUS_HALF_MB(blk, UserDataBlockSize) (((blk) * (UserDataBlockSize) + (1024 * 1024) / 2) / (1024 * 1024))
#define BYTES2MB(bytes) ((bytes) / (1024 * 1024))
#define MB2BLK(mb, UserDataBlockSize) (((mb)*1024 * 1024) / (UserDataBlockSize))

gint32 ProcessLibCommandCall(guint8 libType, SL_LIB_CMD_PARAM_T *plcp);
gint32 lsi_add_ctrl(guint32 ctrl_id);
gint32 lsi_remove_ctrl(guint32 ctrl_id);
gint32 lsi_init_ctrl_manage(guint32 ctrl_id, I2C_WRITE_FUNC i2c_write_func, I2C_WRITEREAD_FUNC i2c_writeread_func);
gint32 lsi_exit_ctrl_manage(guint32 ctrl_id, I2C_WRITE_FUNC i2c_write_func, I2C_WRITEREAD_FUNC i2c_writeread_func);
gint32 FireSCSIPassthruCmd(guint32 ctrl_id, SL_SCSI_PASSTHRU_T *scsi_passthru_cmd);
gint8 ParsePDSenseCode(guint8 *sense_data, guint32 data_len, SCSI_SENSE_DISECT_S *sense_info);
gint32 GetCtrlMFCDefault(guint32 ctrl_id, MR_MFC_DEFAULTS *pCtrlMfcDefault);
void format_sas_addr(guint64 addr, gchar *pAddrBuff, guint32 buffSize);
guint16 GetBlockSizeOfPDInLD(guint32 ctrl_id, guint8 target_id);
gint32 ReadConfig(guint32 ctrl_id, MR_CONFIG_DATA **ppConfig);
gint32 GetCtrlInfo(guint32 ctrl_id, MR_CTRL_INFO *pCtrlInfo);
gint32 GetLDInfo(guint32 ctrl_id, guint8 target_id, MR_LD_INFO *pLdInfo);
gint32 GetPDInfo(guint32 ctrl_id, guint16 deviceId, MR_PD_INFO *pPdInfo);
gint32 GetPDInLD(guint32 ctrl_id, guint8 target_id, SL_PD_IN_LD_T *pLdInfo);
gint32 GetTopologyInfo(guint32 ctrl_id, guint32 buff_len, void *topology_buffer);
gint32 GetLDAssociatedArrays(guint32 ctrl_id, guint8 target_id, SML_ARRAY_LIST_S *pArrayList, MR_LD_INFO *pLdPreInfo);
gint32 GetArrayInfo(guint32 ctrl_id, guint16 array_ref, SL_ARRAY_INFO_T *pArrayInfo);
gint32 AddConfig(guint32 ctrl_id, MR_CONFIG_DATA *pConfigData, guint32 config_size, guint16 target_id);
guint32 check_ld_exist(guint32 ctrl_id, guint8 target_id);
gint32 GetLDListQuery(guint32 ctrl_id, guint8 *targetIdList, guint8 qtype, guint8 *number);
gint32 GetBIOSData(guint32 ctrl_id, MR_BIOS_DATA *biosData);
gint32 DeleteLD(guint32 ctrl_id, guint8 target_id);
gint32 SendSCSIRequestSenseCommand(guint32 ctrl_id, guint16 device_id, SCSI_SENSE_DISECT_S *sense_info);
gint32 SendSCSIDiagnosticCommand(guint32 ctrl_id, guint16 device_id, guint8 func_code);
gint32 lsi_register_event_handler(HANDLE_EVENT_INFO_FUNC event_handler);
extern DRIVE_VENDOR_INFO_EXTEND_S *drive_info_list_lsi;
extern size_t drive_info_list_lsi_len;

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
