/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef HS_PD_SAS_LOG_H
#define HS_PD_SAS_LOG_H
#include "sml_pd.h"
#include "sml_public.h"
#include "histore/lib_api.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 get_sas_device_self_test_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *self_test_log);
gint32 get_sas_device_write_error_count_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *write_error_log);
gint32 get_sas_device_read_error_count_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *read_error_log);
gint32 get_sas_device_verify_error_count_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *verify_error_log);
gint32 get_sas_device_nonmedium_error_count_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *nonmedium_error_log);
gint32 get_sas_device_phy_error_count_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *phy_error_log);
gint32 get_sas_device_internal_exception_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *ie);
gint32 get_sas_device_temperature_log(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *temperature_log);
gint32 get_sas_device_bms_log(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *bms);
gint32 get_sas_device_glist(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *glist);
gint32 get_sas_log_general_statistics(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_huawei_specific32h(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_huawei_specific34h(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_huawei_specific35h(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_huawei_io_info(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_kioxia_ssd_specific(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_kioxia_eopt(guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 get_sas_log_kioxia_smart_data(
    guint32 ctrl_id, guint16 device_id, SML_PD_INFO_S *pd, SML_PD_LOG_DATA_S *p_pd_log);
gint32 send_read_hssd_io_info_scsi_command(
    guint32 ctrl_id, guint16 device_id, guint8 **pbuf, guint32 *buf_size, guint32 *scsi_status);

gint32 send_scsi_read_defect_command12(
    guint32 ctrl_id, guint16 device_id, guint32 *scsi_status, guint32 *defect_list_length);
void component_hssd_io_info_scsi_command(
    struct cmd_scsi_passthrough *scsi_passthru_cmd, guint16 device_id, guint16 page_length);
gint32 send_scsi_read_defect_command12_by_defect_list_length(guint32 ctrl_id, guint16 device_id,
    guint16 defect_list_length, guint8 **pbuf, guint32 *scsi_status);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif
