/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __HS_MISC_H__
#define __HS_MISC_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */
#define PCIE_PHYSICAL_FUCTION0 0

#define HISTORE_CMD_TIMEOUT_DEFAULT 30000   /* 1880带外指令默认超时时间：30000ms */
#define HISTORE_CMD_TIMEOUT_MAX     60000   /* 1880带外指令长超时时间：60000ms */

typedef enum tag_cache_type {
    CACHE_TYPE_VD = 0,
    CACHE_TYPE_RG,
    CACHE_TYPE_SG,
    CACHE_TYPE_BUTT,
} CACHE_TYPE_E;

// 子组索引信息
typedef struct tag_sub_group_index {
    guint16 rg_id;
    guint8 sg_index;
} SUB_GROUP_INDEX_S;

typedef struct tag_cache_vd_info {
    struct cmd_vd_info vd_info;
    guint8 read_count;
} CACHED_VD_INFO;

typedef struct tag_cache_rg_info {
    struct cmd_rg_info rg_info;
    guint8 read_count;
} CACHED_RG_INFO;

typedef struct tag_page_code_info_req {
    guint32 ctrl_id;
    guint16 device_id;
    guint8 page_code;
    guint8 sub_page_code;
} page_code_info_req;

gint32 libhistore_init(struct store_lib_conf *conf);
gint32 libhistore_exit(void);
gint32 histore_add_ctrl(guint32 ctrl_id);
gint32 histore_get_ctrl_parsed_log(const gchar *bin_file_path, const gchar *txt_file_path);
gint32 histore_remove_ctrl(guint32 ctrl_id);
GHashTable *get_cache_hash_table(guint32 ctrl_id, guint8 cache_type);
void insert_data_to_hash_table(guint32 ctrl_id, guint16 target_id, gpointer data, gsize data_len, guint8 cache_type);
gint32 find_data_from_hash_table(guint32 ctrl_id, guint16 target_id, gpointer data, gsize data_len, guint8 cache_type);
void remove_invalid_vd_cache(guint32 ctrl_id, struct cmd_vds_id *vds_id);
void remove_invalid_rg_cache(guint32 ctrl_id, struct cmd_rgs_id *rgs_id);
gint32 process_histore_cmd(struct lib_cmd_param *param);
gint32 get_vd_info(guint32 ctrl_id, guint16 target_id, struct cmd_vd_info *vd_info);
gint32 get_rg_info(guint32 ctrl_id, guint16 target_id, struct cmd_rg_info *rg_info);
gint32 get_pd_basic_info(guint32 ctrl_id, guint16 device_id, struct cmd_show_disk *pd_info);
gint32 get_vd_list(guint8 ctrl_id, struct cmd_vds_id *vd_list);
void clear_vd_cache_read_count(guint32 ctrl_id, guint16 target_id);
void clear_vd_cache_read_count_all(guint32 ctrl_id);
guint32 get_ctrl_jbod_enabled(guint32 ctrl_id);
gint32 send_scsi_passthru_cmd(
    guint32 ctrl_id, struct cmd_scsi_passthrough *scsi_passthru_cmd, gpointer data, guint32 data_length);
gint32 send_scsi_log_sense_command(page_code_info_req *req, guint8 **pbuf, guint32 *buf_size, guint32 *scsi_status);
gint32 get_scsi_device_support_log_pages(guint32 ctrl_id, guint16 device_id, guint8 page_code, guint8 *lp_support);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif