/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
 
#include "sml_errcodes.h"
#include "vendor.h"
 
static const SML_CTRL_ID g_sml_histore_ctrl[] = {
#ifdef ITEST_ENABLED
    {ITEST_SIMULATE, VENDER_ITEST_SIMULATE, 0},
#endif
    {HI1880_SP186_M_8i, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SP186_M_16i, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SP186_M_32i, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SP186_M_40i, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SPR110, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SPR120, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SPR130, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SPR140, VENDER_HUAWEI, HISTORE_TYPE_HBA << TYPE_OFFSET},
    {HI1880_SP686C_M_16i_2G, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SP686C_M_16i_4G, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SP686C_MH_32i_4G, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SP686C_M_40i_2G, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SP686C_M_40i_4G, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SPR180, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SPR185, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SPR190, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SPR1A0, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET},
    {HI1880_SPR1A5, VENDER_HUAWEI, HISTORE_TYPE_RAID << TYPE_OFFSET}
};
 
/*
 Description: histore构建控制器id
 */
gint32 construct_ctrl_id(SML_CTRL_OOB_INFO_S *ctrl, guint32 *controller_id, gint8 *vender_index)
{
    guint8 ctrl_index = ctrl->i_controller_index;
    guint8 ctrl_typeid = ctrl->i_controller_typeid;
 
    // 根据typeid组装controllerID
    guint8 size = (guint8)G_N_ELEMENTS(g_sml_histore_ctrl);
    for (guint8 i = 0; i < size; i++) {
        if (ctrl_typeid == g_sml_histore_ctrl[i].type_id) {
            *controller_id = g_sml_histore_ctrl[i].controller_id | ctrl_index;
            *vender_index = g_sml_histore_ctrl[i].vendor_id;
            return SML_SUCCESS;
        }
    }
    return SML_ERR_CTRL_PARAM_ILLEGAL;
}