/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
// don't change the include order
#include "diagnose.h"
#include "sml_errcodes.h"

/*
 * Description: APP调用该接口诊断Expander与RAID卡之间的通信故障
 * History: 1.2019年1月5日,
 *          新生成函数
 */
gint32 sml_diagnose_encl_comm_error(SML_PD_FAULT_ANALYSIS *diag_info)
{
    gint32 ret = SML_SUCCESS;
    guint32 encl_comm_error_state = 0;

    if (diag_info == NULL) {
        return SML_ERR_NULL_DATA;
    }

    ret = smlib_diagnose_encl_comm_error(diag_info->i_controller_index, diag_info->i_pd_device_id,
        diag_info->i_encl_device_id, &encl_comm_error_state);
    if (ret == SML_SUCCESS) {
        diag_info->o_fault_bitmap.encl_comm_error = encl_comm_error_state;
    }

    return ret;
}

/*
 * Description: APP调用该接口诊断硬盘的sense error
 * History: 1.2019年1月10日,
 *          新生成函数
 */
gint32 sml_diagnose_pd_sense_error(SML_PD_FAULT_ANALYSIS *diag_info)
{
    gint32 ret = SML_SUCCESS;
    guint32 sense_error_state = 0;

    if (diag_info == NULL) {
        return SML_ERR_NULL_DATA;
    }

    ret = smlib_diagnose_pd_sense_error(diag_info->i_controller_index, diag_info->i_pd_device_id,
        diag_info->io_buf, &sense_error_state);
    if (ret == SML_SUCCESS) {
        diag_info->o_fault_bitmap.sense_error = sense_error_state;
    }

    return ret;
}

/*
 * Description: 模拟在诊断信息链表中插入诊断事件
 * History: 1.2019年1月11日,
 *          新生成函数
 */
gint32 sml_mock_ctrl_event(guint8 ctrl_index, guint8 mock_count, SML_MOCK_CTRL_EVENT_S *mock_event)
{
    gint32 ret = SML_SUCCESS;

    ret = smlib_mock_ctrl_event(ctrl_index, mock_count, mock_event);

    return ret;
}
