/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef TYPES_H
#define TYPES_H

#include "sml_public.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#pragma pack(1)

/*----------------------------------------------*
 * 宏定义                                       *
 *----------------------------------------------*/
#define SMLIB_UPDATE_CACHE_DATA_INTREVAL 10
#define SMLIB_PHY_DIAG_HISTORY_RECORD_COUNT 6                    // 最多记录6次历史数据
#define SMLIB_CTRL_INFO_MASK \
    (CTRL_INFO_TYPE_CTRL | CTRL_INFO_TYPE_HEALTH | CTRL_INFO_TYPE_SAS_ADDR | CTRL_INFO_TYPE_BBU | CTRL_INFO_TYPE_PHY)

typedef gint32 (*AddCtrlFunc)(guint32 ctrl_id);
typedef gint32 (*RemoveCtrlFunc)(guint32 ctrl_id);
typedef gint32 (*CtrlOverI2CManangeFunc)(guint32 ctrl_id, I2C_WRITE_FUNC i2c_write_func,
    I2C_WRITEREAD_FUNC i2c_writeread_func);
typedef gint32 (*RegisterHandleEventInfoFunc)(HANDLE_EVENT_INFO_FUNC handle_event_info_func);
typedef gint32 (*CtrlOverPcieManangeFunc)(guint32 ctrl_id, MCTP_WRITEREAD_FUNC mctp_writeread_func);
typedef gint32 (*UpdateCtrlCacheFunc)(guint32 ctrl_id);
typedef gint32 (*CtrlInfoFunc)(guint32 ctrl_id, gpointer data);
typedef gint32 (*LDInfoFunc)(guint32 ctrl_id, guint16 target_id, gpointer data);
typedef gint32 (*PDInfoFunc)(guint32 ctrl_id, guint16 device_id, gpointer data);
typedef gint32 (*PDInfoFuncSpec)(guint32 ctrl_id, guint16 device_id, gpointer data, guint8 filter);
typedef gint32 (*PDOperationFunc)(guint32 ctrl_id, guint16 device_id, guint8 operation, gpointer param,
    guint32 param_length);
typedef gint32 (*PDLogFunc)(guint32 ctrl_id, guint16 device_id, gpointer param, gpointer data);
typedef gint32 (*EnclDiagFunc)(guint32 ctrl_id, guint16 pd_device_id, guint16 encl_device_id,
    guint8 is_encl_single, gpointer data);
typedef gint32 (*PDDiagFunc)(guint32 ctrl_id, guint16 device_id, gchar *detail_desc, gpointer data);

typedef gint32 (*ArrayInfoFunc)(guint32 ctrl_id, guint16 array_ref, gpointer data);
typedef gint32 (*ConfigOperationFunc)(guint32 ctrl_id, guint8 operation, gpointer param,
    guint32 param_length);
typedef gint32 (*LDOperationFunc)(guint32 ctrl_id, guint16 target_id, guint8 operation, gpointer param,
    guint32 param_length);
typedef gint32 (*CtrlOperationFunc)(guint32 ctrl_id, guint8 operation, gpointer param, guint32 param_length);
typedef gint32 (*CtrlParseBinLogFunc)(const gchar *bin_file_path, const gchar *txt_file_path);
typedef gint32 (*PdTransVendorInfo)(const gchar *vender_map_json_str);

typedef enum _tag_smlib_raid_refresh_type {
    RAID_REFRESH_DEFAULT,        // 按照默认的方式刷新数据，按时间刷新
    RAID_REFRESH_CONTROLLER,     // 指定从控制器刷新数据
    RAID_REFRESH_INTERNAL_CACHE, // 指定从内部缓存刷新数据
} SML_RAID_REFRESH_TYPE_E;

typedef enum _tag_smlib_cache_data_valid_type {
    CACHE_DATA_VALID,           // 缓存数据有效
    CACHE_DATA_INVALID_TIMEOUT, // 缓存数据由于超过更新时间间隔变得无效
    CACHE_DATA_INVALID_NO_DATA, // 缓存区域没有数据，需要更新(比如刚初始化/对象刚创建)
    CACHE_DATA_INVALID_FORCED,  // 缓存数据被强制设置为无效，这表示数据已经有变更，需要立即获取
} SML_RAID_CACHE_DATA_VALIDITY_TYPE_E;

/* 结构体新增成员变量时注意四字节对齐！！！ */
typedef struct _tag_sml_ctrl {
    GMutex ctrl_mutex;
    GMutex op_mutex; // RAID控制器进行实际操作的互斥锁，即同一时刻，RAID只执行一个硬件操作(设置或查询)
    guint8 is_registered;    // RAID控制器是否已被注册
    guint8 init_state;       // RAID控制器初始化状态
    guint8 controller_index; // RAID控制器的索引号，从0开始
    guint8 reserved;

    guint32 controller_id;
    SML_CTRL_INFO_S controller;
    AddCtrlFunc pfn_add_ctrl;
    RemoveCtrlFunc pfn_remove_ctrl;
    CtrlOverI2CManangeFunc pfn_init_ctrl_over_i2c;
    CtrlOverI2CManangeFunc pfn_exit_ctrl_over_i2c;
    CtrlOverPcieManangeFunc pfn_init_ctrl_over_pcie;
    CtrlOverPcieManangeFunc pfn_exit_ctrl_over_pcie;
    UpdateCtrlCacheFunc pfn_update_ctrl_cache;
    CtrlInfoFunc pfn_get_ctrl_info;
    CtrlInfoFunc pfn_get_ctrl_health;
    CtrlInfoFunc pfn_get_ctrl_sas_addr;
    CtrlInfoFunc pfn_get_ctrl_bbu_status;
    CtrlInfoFunc pfn_get_ctrl_phy_err_count;
    CtrlInfoFunc pfn_get_ctrl_exp_phy_err_count;
    CtrlInfoFunc pfn_get_ctrl_ld_list;
    CtrlInfoFunc pfn_get_ctrl_pd_list;
    CtrlInfoFunc pfn_get_ctrl_exp_list;
    CtrlInfoFunc pfn_get_exp_phy_err_count;
    LDInfoFunc pfn_get_ld_info;
    LDInfoFunc pfn_get_ld_pd_list;
    PDInfoFunc pfn_get_pd_info;
    PDInfoFunc pfn_get_pd_smart_info;
    PDInfoFuncSpec pfn_get_pd_smart_info_spec;
    PDLogFunc pfn_get_pd_log;
    PDOperationFunc pfn_pd_operation;
    EnclDiagFunc pfn_diag_encl_comm_error;
    PDDiagFunc pfn_diag_pd_sense_error;
    CtrlInfoFunc pfn_mock_diag_ctrl_event;
    PDInfoFunc pfn_get_phy_diag_topo_info;
    RemoveCtrlFunc pfn_clear_ctrl_diag_event;
    RegisterHandleEventInfoFunc pfn_register_handle_event_info;
    CtrlInfoFunc pfn_get_ctrl_array_list;
    ArrayInfoFunc pfn_get_array_info;
    CtrlInfoFunc pfn_get_ctrl_boot_mode;
    // config & set functions
    ConfigOperationFunc pfn_config_operation;
    LDOperationFunc pfn_ld_operation;
    CtrlOperationFunc pfn_ctrl_operation;
    CtrlParseBinLogFunc pfn_get_ctrl_parsed_log;
    PdTransVendorInfo pfn_trans_drive_data;
} SML_CTRL_S;

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
