/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef PD_H
#define PD_H

#include "types.h"
#include "sml.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 smlib_get_pd_info(guint8 ctrl_index, guint16 pd_device_id, SML_PD_BASIC_INFO_S *pd);
gint32 smlib_get_pd_log(guint8 ctrl_index, guint16 pd_device_id, SML_PD_LOG_DATA_S *pd_log);
/* 支持采集的数据列表 */
gint32 smlib_get_pd_smart_info(guint8 ctrl_index, guint16 pd_device_id, SML_PD_SMART_INFO_S *pd_smart_info);

gint32 smlib_dump_smart_info(guint8 ctrl_index, gchar *file_path, gchar *file_short_name);
gint32 smlib_exec_pd_operation(guint8 ctrl_index, guint16 pd_device_id, guint8 operation, gpointer param,
    guint32 param_length);
void smlib_parse_ata_smart_attr_raw_value(gchar *buf, guint32 buf_size, ATA_SMART_ATTRIBUTE_S *smart_attr,
    guint8 *format);
const gchar *smlib_get_ata_smart_attr_name(guint8 attr_id);
gint32 smlib_get_pd_sas_smart_info(guint8 ctrl_index, guint16 pd_device_id, SML_PD_SAS_SMART_INFO *smart_info);
gint32 smlib_get_pd_sas_smart_info_spec(
    guint8 ctrl_index, guint16 pd_device_id, SML_PD_SAS_SMART_INFO *smart_info, guint8 filter);
gint32 smlib_get_pd_slow_disk_info(guint8 ctrl_index, guint16 pd_device_id, void *slow_disk_info);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
