/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef LD_H
#define LD_H

#include "types.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

gint32 smlib_get_array_info(guint8 ctrl_index, guint16 array_ref, SML_ARRAY_INFO_S *array);
gint32 smlib_get_ld_info(guint8 ctrl_index, guint16 ld_target_id, SML_LD_BASIC_INFO_S *ld);
gint32 smlib_get_ld_pd_list(guint8 ctrl_index, guint16 ld_target_id, SML_PD_LIST_S *ld);
gint32 smlib_exec_config_operation(guint8 ctrl_index, guint8 operation, gpointer param, guint32 param_length);
gint32 smlib_exec_ld_operation(guint8 ctrl_index, guint16 ld_target_id, guint8 operation, gpointer param,
    guint32 param_length);
gint32 smlib_is_ssd_in_ld(guint8 ctrl_index, guint16 ld_target_id);
gint32 smlib_get_sscd_list(guint8 ctrl_index, guint16 *target_ids, guint8 *sscd_count);
gint32 smlib_get_ld_sscd_caching_enable(guint8 ctrl_index, guint16 target_id, guint8 *enable);
gint32 smlib_update_ld_spare_pd_slots(guint8 ctrl_index, guint16 target_id);
gint32 smlib_get_pds_info_for_ld_creation(guint8 ctrl_index, guint16 *pd_ids, guint8 pd_count,
    SML_CREATE_LD_PD_INFO_S *pd_infos);
gint32 smlib_get_ctrl_info_for_ld_creation(guint8 ctrl_index, SML_CREATE_LD_CTRL_INFO_S *ctrl_info);
gint32 smlib_get_ld_ref_array(guint8 ctrl_index, guint16 target_id, guint16 *ref_array, guint8 *array_count);
gint32 smlib_is_last_ld_on_array(guint8 ctrl_index, guint16 target_id);
gint32 smlib_resort_array_infos(guint8 ctrl_index, guint16 *array_refs, guint8 array_count);
gint32 smlib_get_pd_ids_in_ld(guint8 ctrl_index, guint16 target_id, guint16 *pd_ids, guint8 *pd_count);
void smlib_refresh_infos_after_ld_delete(guint8 ctrl_index, guint16 ld_target_id);
guint16 smlib_get_pd_block_size_in_array(guint8 ctrl_index, guint16 array_ref);
gint32 smlib_get_ld_associated_sscd_list(SML_LD_ASSOCIATED_SSCD_LIST_S* ld);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
