/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef __SML_DIAGNOSE_H__
#define __SML_DIAGNOSE_H__

#include "types.h"
#include "sml.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#pragma pack(1)

#define SMLIB_PHY_DIAG_HISTORY_TIME_TOLERANCE (3 * 60 * 60 * 1000) // 历史数据有效时间限制为3个小时
#define SMLIB_DELAY_HALF_MINUTE 30000

gint32 smlib_diagnose_encl_comm_error(guint8 ctrl_index, guint16 pd_device_id, guint16 encl_device_id,
    guint32 *comm_error_state);
gint32 smlib_diagnose_pd_sense_error(guint8 ctrl_index, guint16 pd_device_id, gchar *io_buf,
    guint32 *sense_error_state);
gint32 smlib_diagnose_link_phy_error(SML_PD_FAULT_ANALYSIS *diag_info, guint32 serial_threshold,
    guint32 recent_threshold);
gint32 smlib_mock_ctrl_event(guint8 ctrl_index, guint8 mock_count, SML_MOCK_CTRL_EVENT_S *mock_event);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
