/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef CTRL_H
#define CTRL_H

#include "types.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

guint8 smlib_get_ctrl_init_state(guint8 ctrl_index);
gint32 smlib_get_ctrl_info(guint8 ctrl_index, SML_CTRL_BASIC_INFO_S *ctrl);
gint32 smlib_get_ctrl_sas_addr(guint8 ctrl_index, SML_SAS_ADDR_S *ctrl);
gint32 smlib_get_ctrl_bbu_status(guint8 ctrl_index, SML_BBU_STATUS_S *ctrl);
gint32 smlib_get_ctrl_health(guint8 ctrl_index, SML_CTRL_HEALTH_S *ctrl);
gint32 smlib_get_ctrl_phy_err_count(guint8 ctrl_index, SML_SASPHY_INFO_S *ctrl, guint8 force_update);
gint32 smlib_get_ctrl_exp_phy_err_count(guint8 ctrl_index, SML_CTRL_EXP_SASPHY_INFO_S *expander);
gint32 smlib_get_ctrl_ld_list(guint8 ctrl_index, SML_LD_LIST_S *ctrl);
gint32 smlib_get_ctrl_pd_list(guint8 ctrl_index, SML_PD_LIST_S *ctrl);
gint32 smlib_get_ctrl_array_list(guint8 ctrl_index, SML_ARRAY_LIST_S *ctrl);
gint32 smlib_get_ctrl_boot_mode(guint8 ctrl_index, guint8 *boot_mode);
gint32 smlib_exec_ctrl_operation(guint8 ctrl_index, guint8 operation, gpointer param, guint32 param_length);
gint32 smlib_get_ctrl_boot_devices(SML_CTRL_BOOTABLE_DEVICES_S *boot_devices);
gint32 smlib_exec_parse_ctrl_log(guint8 ctrl_index, const gchar *src_dir, const gchar *dest_dir);
gint32 smlib_exec_pd_trans_drive_data(guint8 ctrl_index, const gchar *json_raw_str);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
