/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
 
#ifndef ADAPTER_H
#define ADAPTER_H

#include "types.h"
#include "sml.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#pragma pack(1)

typedef struct _tag_smlib_sdk_func {
    void **pfunc;
    const gchar *func_name;
} SMLIB_SDK_FUNC_S;

SML_CTRL_S* get_ctrl_by_index(guint8 ctrl_index);
void lock_ctrl_list_mutex(guint8 ctrl_index);
void unlock_ctrl_list_mutex(guint8 ctrl_index);
gint32 check_cache_data_is_expired(guint8 refresh_polciy, guint32 current, guint32 last, guint32 interval);
guint8 update_refresh_policy(guint8 refresh_polciy);
gint32 check_input_parameters(guint8 ctrl_index, gpointer input);
gint32 check_ld_target_id(guint16 ld_target_id, SML_LD_LIST_S *ld_list, guint8 *ld_index);
gint32 check_pd_device_id(guint16 pd_device_id, SML_PD_LIST_S *pd_list, guint16 *pd_index);
gint32 fd_record_ctrl_phy_err_info(SML_PHY_DIAG_HISTORY_INFO_S *history_info, SML_SASPHY_INFO_S *ctrl_phy_info,
    guint32 collect_timestamp);
gint32 fd_record_exp_phy_err_info(SML_PHY_DIAG_HISTORY_INFO_S *history_info,
    SML_CTRL_EXP_SASPHY_INFO_S *exp_phy_info, guint32 collect_timestamp);

void smlib_init(void);
void smlib_clear_all_controller_info(void);
gint32 smlib_add_ctrl(SML_CTRL_OOB_INFO_S *ctrl);
gint32 smlib_init_ctrl_manage(SML_CTRL_OOB_INFO_S *ctrl);
gint32 smlib_exit_ctrl_manage(SML_CTRL_OOB_INFO_S *ctrl);
gint32 smlib_remove_ctrl(guint8 ctrl_index);
gint32 smlib_update_ctrl_cache(guint8 ctrl_index);
void smlib_invalid_ctrl_cached_info(guint8 ctrl_index, guint32 type_mask);

void smlib_refresh_specfied_ld_from_hw_next(guint8 ctrl_index, guint16 ld_target_id, guint8 refresh_cnt);
void smlib_refresh_all_lds_from_cache_next(guint8 ctrl_index, guint8 refresh_cnt);
void smlib_refresh_specfied_arrays_from_hw_next(guint8 ctrl_index, guint16 *array_refs, guint8 array_count,
    guint8 refresh_cnt);
void smlib_refresh_all_arrays_from_cache_next(guint8 ctrl_index, guint8 refresh_cnt);
void smlib_refresh_specfied_pds_from_hw_next(guint8 ctrl_index, guint16 *pd_ids, guint8 pd_count,
    guint8 refresh_cnt);
void smlib_refresh_all_pds_from_cache_next(guint8 ctrl_index, guint8 refresh_cnt);
void smlib_refresh_all_other_from_cache_next(guint8 ctrl_index, guint8 refresh_cnt);
void smlib_clear_boot_priority_from_cache(SML_CTRL_S* sml_ctrl, guint8 boot_priority);
void smlib_fill_err_msg(gint32 err_code, gchar *err_msg, gint32 max_len);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif
