/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 *
 * this file licensed under the Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 *
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
 * PURPOSE.
 * See the Mulan PSL v2 for more details.
 *
 */
#ifndef PLATFORM_H
#define PLATFORM_H

#include <fcntl.h>
#include <glib-2.0/glib.h>
#include <utils/vos.h>
#include <secure/securec.h>
#include <sys/stat.h>
#include <unistd.h>
#include <inttypes.h>
#include "json_api.h"
#include "logging.h"

// 公共定义
#define RET_OK  0
#define RET_ERR (-1)

#define DISABLE 0
#define ENABLE  1

#define MAX_FILE_NAME_LEN   256
#define MAX_FILEPATH_LENGTH    256  /* 文件路径最大长度 */

/* 指针与整型变量之间的转换宏定义 */
#define POINTER_TO_INT8(p) ((gint8)(intptr_t)(p))
#define POINTER_TO_INT16(p) ((gint16)(intptr_t)(p))
#define POINTER_TO_INT32(p) ((gint32)(intptr_t)(p))
#define POINTER_TO_UINT8(p) ((guint8)(uintptr_t)(p))
#define POINTER_TO_UINT16(p) ((guint16)(uintptr_t)(p))
#define POINTER_TO_UINT32(p) ((guint32)(uintptr_t)(p))

#define INT8_TO_POINTER(i) ((gpointer)(intptr_t)(i))
#define INT16_TO_POINTER(i) ((gpointer)(intptr_t)(i))
#define INT32_TO_POINTER(i) ((gpointer)(intptr_t)(i))
#define UINT8_TO_POINTER(u) ((gpointer)(uintptr_t)(u))
#define UINT16_TO_POINTER(u) ((gpointer)(uintptr_t)(u))
#define UINT32_TO_POINTER(u) ((gpointer)(uintptr_t)(u))

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */
gint g_fprintf(FILE *file, gchar const *format, ...) G_GNUC_PRINTF(2, 3);
gint g_printf(gchar const *format, ...) G_GNUC_PRINTF(1, 2);

void vos_task_delay(guint32 millisecond);
gulong vos_tick_get(void);
gulong arith_make_crc32(gulong crc, const guint8 *buf, gulong length);
gulong vos_get_cur_time_stamp(void);
gchar *string_clear_blank(gchar *string_src, guint32 string_src_size);
gint32 vos_get_file_dir(const gchar *filename, gchar *filepath, guint32 path_len);
gint32 dal_localtime_r(const time_t *p_time_stamp, struct tm *p_tm);
const gchar* dal_json_object_get_str(Json *obj);

#define GET_ARRAY_ITEMS(x) (sizeof(x) / sizeof(((x)[0])))

#define MAKE_WORD(a, b) ((guint16)(((guint8)(b)) | (((guint16)((guint8)(a))) << 8)))
#define MAKE_DWORD(a, b, c, d) ((guint32)MAKE_WORD(c, d) | (guint32)(MAKE_WORD(a, b) << 16))

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif