/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef SUBHEALTHY_LOG_PROCESS_H
#define SUBHEALTHY_LOG_PROCESS_H

#include "sml.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define PD_MANUFACTURER_LENGTH 32

typedef struct write_amp_last_info {
    gboolean first_start_flag;
    guint64 last_nand_written;
    guint64 last_host_written;
} WRITE_AMP_LAST_INFO_S;

// 通过从Smart Info捞取上来的信息, 对硬盘写放大量进行计算, 并将计算结果写入文件, 写放大量(Write Amplification Factor)
void calc_and_save_write_amp_value_by_smart_info(char *device_name, guint32 est_lfsp_value,
    SML_PD_SSD_WRITE_AMP_FACTOR_S *write_amp_info, WRITE_AMP_LAST_INFO_S *write_amp_last_info,
    Json *disk_write_amp_jso);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
#endif