/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SATA_LOG_H__
#define __SATA_LOG_H__

#include "sata_log_parse.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define PD_LOG_SATA_SMART_ATTR_FILE "SMARTAttribute"
#define PD_LOG_SATA_SMART_ATTR_THE_FILE "SMARTAttributeThreshold"
#define PD_LOG_SATA_ERR_LOG_FILE "ErrorLog"
#define PD_LOG_SATA_EXT_ERR_LOG_FILE "ExtentErrorLog"
#define PD_LOG_SATA_SELF_TEST_LOG_FILE "ExtendedSelfTestLog"
#define PD_LOG_SATA_PHY_EVENT_LOG_FILE "PHYEventLog"

#define PD_LOG_SEAGATE_GLIST_FILE "SeagateGList"
#define PD_LOG_SEAGATE_PLIST_FILE "SeagatePList"
#define PD_LOG_SEAGATE_CRT_EVENT_FILE "SeagateCriticalEventLog"
#define PD_LOG_SEAGATE_FARM_LOG_FILE "SeagateFARMLog"

#define SUBHEALTHY_RECORD_CONTENT_SIZE 256
#define SUBHEALTHY_FILE_MAX_LINES 31   // 记录日志文件头以及30条数据
#define PD_LOG_SUBHEALTHYT_RECORD_FILE "SubhealthyRecord"
#define PD_LOG_EXT_NAME "csv"

void pd_log_handle_sata(PD_LOG_S *pd_log, Json *pd_log_jso);
gint32 pd_log_collect_sata_from_oob(guint8 ctrl_index, guint16 pd_device_id, PD_LOG_S *pd_log);
gint32 pd_log_check_farm_supported(PD_LOG_S *pd_log);
void pd_log_ssd_save_subhealthy_record_file(char *device_name, guint32 est_lfsp_value, guint32 write_amp_value);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __SATA_LOG_H__ */
