/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SAS_LOG_PARSE_H__
#define __SAS_LOG_PARSE_H__

#include "sas_ie_log_parse.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

void pd_log_handle_sas_self_test(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_error_cnt(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_phy_error_cnt(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_glist(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_temperature(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_bms(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_solid_state_media(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_general_statistics(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *pd_log_jso);
void pd_log_handle_sas_huawei_specific32h(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_huawei_specific34h(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_huawei_specific35h(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_huawei_io_info(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_kioxia_ssd_specific(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_kioxia_eopt(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
void pd_log_handle_sas_kioxia_smart_data(FILE *file, PD_LOG_S *pd_log, void *out_put, Json *vendor_log_json);
guint8 pd_log_sas_glist_get_format_len(guint8 format_type);
void pd_log_scsi_decode_non_medium_err_counter(guchar *non_medium_data, guint32 non_medium_data_len,
    SCSI_NON_MEDIUM_ERROR_S *non_medium);
void pd_log_scsi_decode_err_counter(guchar *error_counter_data, guint32 error_counter_data_len,
    SCSI_ERROR_COUNTER_S *error_counter, guint32 counter_size);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __SAS_LOG_PARSE_H__ */
