/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __SAS_LOG_H__
#define __SAS_LOG_H__

#include "sas_log_parse.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define PD_LOG_SAS_SELF_TEST_LOG_FILE "SelfTestLog"
#define PD_LOG_SAS_WRITE_ERR_LOG_FILE "WriteErrorCountLog"
#define PD_LOG_SAS_READ_ERR_LOG_FILE "ReadErrorCountLog"
#define PD_LOG_SAS_VERIFY_ERR_LOG_FILE "VerifyErrorCountLog"
#define PD_LOG_SAS_MEDIUM_ERR_LOG_FILE "NonmediumErrorCountLog"
#define PD_LOG_SAS_PHY_ERR_LOG_FILE "PHYErrorCountLog"
#define PD_LOG_SAS_IE_LOG_FILE "InternalExceptionLog"
#define PD_LOG_SAS_TEM_LOG_FILE "TemperatureLog"
#define PD_LOG_SAS_BMS_LOG_FILE "BMSLog"
#define PD_LOG_SAS_GLIST_FILE "GList"

gint32 pd_log_collect_sas_from_oob(guint8 ctrl_index, guint16 pd_device_id, PD_LOG_S *pd_log);
void pd_log_handle_sas(PD_LOG_S *pd_log, Json *pd_log_jso);
#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __SAS_LOG_H__ */
