/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __PD_LOG_PROCESS_H__
#define __PD_LOG_PROCESS_H__

#include "sml_pd.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define PD_LOG_COLLECT_TIMEOUT (180 * 1000) // 单个日志数据收集的超时时间180s

#define PD_LOG_BASE_PATH "/data/var/log/storage/drivelog"
#define MAX_FILENAME_LEN       200  /* 文件名最大长度 */
#define MAX_CMD_BUF_LEN        256  /* 拼装shell命令的最大长度 */
#define TMP_STR_LEN 128


#define G_GUINT64_HEX_FORMAT "lx"

#define PD_LOG_SOURCE_OOB 0
#define PD_LOG_SOURCE_BMA 1

typedef gint32 (*SmlibGetPdLog)(SML_PD_LOG_S *pd);
typedef const gchar* (*SmlGetAtaSmartAttrName)(guint8 attr_id);
typedef void (*SmlParseAtaSmartAttrRawValue)(gchar *buf, guint32 buf_size, ATA_SMART_ATTRIBUTE_S *smart_attr,
    guint8 *format);

typedef struct _pd_log_parse {
    SmlibGetPdLog sml_get_pd_log;
    SmlGetAtaSmartAttrName sml_get_ata_smart_attr_name;
    SmlParseAtaSmartAttrRawValue sml_parse_ata_smart_attr_raw_value;
} PD_LOG_PARSE;

gint32 pd_log_check_file_path(const gchar *device_name);
gint32 pd_log_check_raw_data(FILE *file, gint32 result, guint32 scsi_status, guint8 *data, guint32 data_length,
    gulong timeout);

void pd_log_collect_raw_data_from_oob(guint8 ctrl_index, guint16 pd_device_id,
    SML_PD_LOG_DATA_S *pd_log_raw_data, guint32 pd_log_collect_timeout);

void pd_log_write_header(FILE *file, PD_LOG_S *pd_log);

void pd_log_clear_data(PD_LOG_S *pd_log);

void pd_log_fprintf(FILE *file, gchar const * format, ...);
void pd_log_format_time(guint32 time_ms, gchar *str, gint32 str_len);
void check_log_file_rotate(const gchar *base_name, const gchar *ext_name, guint8 max_log_num);

gint32 pd_log_read_file(const gchar *log_file_name, gchar *file_buf, guint32 buf_size, guint32 *p_content_size);
gint32 pd_log_write_file(const gchar *log_file_name, const gchar *file_buf, guint32 content_size);
gint32 get_current_time_stamp(gchar *time_stamp, guint32 len);
gint32 pd_log_buf_insert(gchar *buf, guint32 buf_size, guint32 insert_pos, const gchar *str_to_add,
    guint32 *p_content_size);
gint32 pd_log_buf_delete(gchar *buf, guint32 buf_size, guint32 start_pos, guint32 delete_len,
    guint32 *p_content_size);

void save_pd_log_parse_fun_table(PD_LOG_PARSE **pd_log_parse);
gint32 sml_adapter_get_pd_log(SML_PD_LOG_S *pd);
const gchar *sml_adapter_get_ata_smart_attr_name(guint8 attr_id);
void sml_adapter_parse_ata_smart_attr_raw_value(gchar *buf, guint32 buf_size, ATA_SMART_ATTRIBUTE_S *smart_attr,
    guint8 *format);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __PD_LOG_PROCESS_H__ */
