/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
 
#ifndef __IO_DETERIORATION_LOG_PROCESS_H__
#define __IO_DETERIORATION_LOG_PROCESS_H__
 
#include "sml.h"
 
#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */
 
typedef enum TAG_IO_DETERIORATION_PERIOD_CHANNEL {
    IO_DETERIORATION_MAX_PERIOD_CHANNEL = 0,
    IO_DETERIORATION_UNC_PERIOD_CHANNEL,
    IO_DETERIORATION_ERR_PERIOD_CHANNEL,
    IO_DETERIORATION_CMD_PERIOD_CHANNEL,
    IO_DETERIORATION_PERIOD_CHANNEL_CNT,
} IO_DETERIORATION_PERIOD_CHANNEL;
 
#pragma pack(push)
#pragma pack(1)
// -----------------慢盘检测seagate厂商物理盘的参数
typedef struct TAG_IO_DETERIORATION_DIAG_SEA_LOG_PARAM {
    // farm_log_page2
    guint64 read_cmd_num;
    guint64 write_cmd_num;
    guint64 random_read_cmd_num;
    guint64 random_write_cmd_num;
    guint64 other_cmd_num;
    guint64 logic_sector_written;
    guint64 logic_sector_read;
    // farm_log_page3
    guint64 unrecover_read_errors;
    guint64 unrecover_write_errors;
    guint64 reallocated_sectors;
    guint64 read_recovery_attempts;
    guint64 mechanical_start_failures;
    guint64 reallocated_candidate_sectors;
    guint64 asr_events;
    guint64 interface_crc_errors;
    guint64 spin_retry_count;
    guint64 spin_retry_count_normalized;
    guint64 spin_retry_count_worst;
    guint64 ioedc_errors;
    guint64 cto_total; // 在static表中-
    guint64 cto_over_5s; // 在static表中-
    guint64 cto_over_7_5s; // 在static表中-
    guint64 flash_led_events; // 在static表中-
    guint64 uncorrectable_errors;
    // farm_log_page4
    guint64 high_fly_write_count; // 在static表中-
    // farm_log_page5
    guint64 disc_slip_micro_inches[24];
    guint64 bit_error_rate_zone[24];
    guint64 glist_reclamations_num;
    guint64 servo_status; // 在static表中-
    guint64 alts_list_before_idd;
    guint64 alts_list_after_idd;
    guint64 resident_glist_before_idd;
    guint64 resident_glist_after_idd;
    guint64 scrubs_list_before_idd;
    guint64 scrubs_list_after_idd;
    guint64 dos_scans_performed_num; // 在static表中-
    guint64 lbas_corrected_by_isp_num;
    guint64 valid_parity_sectors_num;
    guint64 dos_write_refresh_count[24]; // 在static表中-
    guint64 raw_operations_num; // 在static表中-
    guint64 dvga_skip_write_detect[24];
    guint64 rvga_skip_write_detect[24];
    guint64 fvga_skip_write_detect[24];
    guint64 skip_write_detect_thred[24]; // 在static表中-
    guint64 error_rate_raw; // 在static表中-
    guint64 micro_actuator_lockout_accumulated;
    guint64 acff_sine_1x[24];
    guint64 acff_cosine_1x[24];
    guint64 pzt_calibration[24]; // 在static表中-
    guint64 mr_head_resistance[24]; // 在static表中-
    guint64 tmd_num[24];
    guint64 velocity_observer[24];
    guint64 velocity_observer_num[24];
    guint64 current_h2sat_trimmed_mean_zone_0[24];
    guint64 current_h2sat_trimmed_mean_zone_1[24];
    guint64 current_h2sat_trimmed_mean_zone_2[24];
    guint64 current_h2sat_iterations_zone_0[24];
    guint64 current_h2sat_iterations_zone_1[24];
    guint64 current_h2sat_iterations_zone_2[24];
    guint64 current_h2sat_percentage_codewords[24];
    guint64 h2sat_amplitude[24];
    guint64 h2sat_asymmetry[24];
    guint64 flyheight_clearance_delta_outer[24]; // 在static表中-
    guint64 flyheight_clearance_delta_inner[24]; // 在static表中-
    guint64 flyheight_clearance_delta_middle[24]; // 在static表中-
    guint64 disc_slip_recalibration_performed; // 在static表中-
    guint64 second_mr_head_resistance[24];
} __attribute__((packed)) IO_DETERIORATION_DIAG_SEA_LOG_PARAM;
 
typedef struct TAG_IO_DETERIORATION_DIAG_SEA_SATA_PARAM {
    guint64 command_timeout_count;
    guint64 reported_uncorrectables;
} IO_DETERIORATION_DIAG_SEA_SATA_PARAM;
 
typedef struct TAG_IO_DETERIORATION_DIAG_OTHER_SATA_PARAM {
    guint64 throughput_performance;
    guint64 seek_time_performance;
} IO_DETERIORATION_DIAG_OTHER_SATA_PARAM;
 
// -----------------慢盘检测sata的参数
typedef struct TAG_IO_DETERIORATION_DIAG_SATA_PARAM {
    guint64 raw_read_error_rate;
    guint64 reallocated_sector_count;
    guint64 seek_error_rate;
    guint64 current_pending_sector;
    guint64 offline_uncorrectable;
    struct {
        IO_DETERIORATION_DIAG_OTHER_SATA_PARAM other_sata_param;
        IO_DETERIORATION_DIAG_SEA_SATA_PARAM sea_sata_param;
    } typical_sata_param;
} IO_DETERIORATION_DIAG_SATA_PARAM;
 
// -----------------慢盘检测sas的参数
typedef struct TAG_IO_DETERIORATION_DIAG_SAS_PARAM {
    gchar hdd_heal_status[PROP_VAL_LENGTH];
    guint32 grown_list;
    guint32 corrected_err_cnt_r;
    guint32 corrected_err_cnt_w;
    guint32 corrected_err_cnt_v;
    guint32 uncorrected_err_cnt_r;
    guint32 uncorrected_err_cnt_w;
    guint32 uncorrected_err_cnt_v;
    guint32 nonmedium_err_cnt;
} IO_DETERIORATION_DIAG_SAS_PARAM;
 
// -----------------慢盘检测RAID卡侧参数
typedef struct TAG_IO_DETERIORATION_DIAG_CTRL_PARAM {
    // 通过LSI_RAID_Controller_log的event_code统计的参数
    guint8 rebuild_progress;    // 物理盘的重构状态
    guint16 health_status;      // 物理盘的健康状态
    guint32 media_error_cnt;    // 物理盘的媒体错误数量
    guint32 prefail_error_cnt;  // 物理盘的预失败错误数量
    guint32 other_err_count;    // 物理盘的其它错误数量
    guint8 unexpected_sense;
    guint8 command_timeout;
    guint8 reset_with_type;
    guint8 power_reset;
} IO_DETERIORATION_DIAG_CTRL_PARAM;
 
typedef struct TAG_IO_DETERIORATION_DIAG_INFO {
    IO_DETERIORATION_DIAG_SATA_PARAM sata_param;
    IO_DETERIORATION_DIAG_SAS_PARAM sas_param;
    IO_DETERIORATION_DIAG_SEA_LOG_PARAM sea_param;
    IO_DETERIORATION_DIAG_SEA_LOG_PARAM sea_factory_param;
    IO_DETERIORATION_DIAG_CTRL_PARAM ctrl_param;
} IO_DETERIORATION_DIAG_INFO;
 
typedef struct TAG_IO_DETERIORATION_DIAG_COUNTED_DATA {
    guint64 unc;
    guint64 err;
    guint64 cmd;
} IO_DETERIORATION_DIAG_COUNTED_DATA;
 
typedef enum FACTORY_FARM_LOG_STATE {
    FACTORY_FARM_LOG_STATE_DEFAULT = 0,
    FACTORY_FARM_LOG_NOT_SUPPORT,
    FACTORY_FARM_LOG_SUPPORT_COLLECT_DATA,
    FACTORY_FARM_LOG_SUPPORT_COLLECT_DATA_DB,
    FACTORY_FARM_LOG_SUPPORT_NOT_COLLECT_DATA
} FACTORY_FARM_LOG_STATE;
typedef struct TAG_IO_DETERIORATION_PD_INFO {
    guint8 pd_interface_type;
    gchar pd_manufacturer[SML_PD_MANUFACTURER_LENGTH];
    gchar pd_serial_number[SML_PD_SN_LENGTH];
    gchar pd_device_name[PROP_VAL_LENGTH];
    FACTORY_FARM_LOG_STATE factory_farm_state;
    IO_DETERIORATION_DIAG_INFO log;
    IO_DETERIORATION_DIAG_COUNTED_DATA counted_data;
} IO_DETERIORATION_PD_INFO;
 
#pragma pack(pop)

void io_deterioration_handle_basic_data(PD_LOG_S *pd_log, Json *pd_io_info_jso);
void io_deterioration_handle_data(PD_LOG_S *pd_log, Json *disk_io_info_jso);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */
 
#endif