/* Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

#ifndef __DIAGNOSE_DEFS_H__
#define __DIAGNOSE_DEFS_H__

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

#define STORAGE_DIAGNOSE_LOG_BASE_PATH "/var/log/storage"

#pragma pack(1)
// 环境当前状态
typedef struct _tag_diag_env_state {
    guint8 oob_supported_state; // RAID带外管理支持状态
    guint8 oob_config_ready;    // RAID信息是否已经至少获取完成一次，已经可以支持配置命令
    guint8 bma_connect_state;   // BMA运行状态
} STORAGE_DIAG_ENV_STATE_S;

// -----------------PHY误码诊断标志状态
typedef struct tag_phy_err_diag_status {
    guint32 sel_reported : 1;          // 标记该PHY在重启以来是否产生过误码增长过快的SEL事件
    guint32 err_cnt_changed : 1;       // 与上次计数相比，误码计数是否有变化
    guint32 err_cnt_change_dir : 1;    // 与上次相比，误码计数变化方向，1降低，0增加
    guint32 increased_over_thresh : 1; // 与上次相比，误码增加是否超过门限
    guint32 phy_err_status_reserved : 28;
} PHY_ERR_DIAG_STATUS_S;

// -----------------PHY误码计数
typedef struct tag_phy_err_count {
    // 是否至少已经获取到一次有效误码计数
    guint8 base_data_obtained;
    // 第一次获取到有效数据的标记
    guint8 first_valid_data;
    // 在已经获取过有效数据的情况下，对连续误码更新失败计数，更新成功后将该数据清0
    guint32 failed_cnt;
    // 数据更新成功时备份记录更新失败的次数，备份failed_cnt的值
    guint32 failed_cnt_bak;

    // PHY个数
    guint8 phy_count;
    // PHY误码分析诊断状态
    PHY_ERR_DIAG_STATUS_S err_status[SML_MAX_SAS_PHY_PER_EXPANDER];
    // PHY误码数据
    SML_SAS_PHY_INFO_S err_cnt_info[SML_MAX_SAS_PHY_PER_EXPANDER];
    // 各phy采集到无效数据的次数统计，采集到有效数据则清零
    guint32 invalid_cnt[SML_MAX_SAS_PHY_PER_EXPANDER];
} PHY_ERR_CNT_S;

// -----------------从文件内容模拟获取PHY计数
typedef struct tag_phy_err_from_file_mgnt_info {
    // 模拟输入文件名称
    gchar file_name[MAX_FILEPATH_LENGTH + 1];
    // 文件模拟输入是否已经开启
    guint8 mock_enabled;
    // 当前从模拟文件中读取的记录序号
    guint32 record_index;

    // 模拟开启命令刚执行标志，从模拟文件获取一次数据后该标志清零
    guint8 mock_first_time;
} PHY_ERR_MOCK_INFO_S;

typedef struct _tag_phy_biterr_diag_info {
    gulong raid_object;
    guint8 obj_index;
    guint8 max_raid_phy_count; // RAID卡本身PHY个数，在XML中配置

    // RAID卡PHY误码相关数据
    PHY_ERR_CNT_S raid_phy;
    PHY_ERR_MOCK_INFO_S raid_mock_mgnt_info;

    // RAID卡连接的Expander下PHY误码相关数据
    guint8 expander_count;
    PHY_ERR_CNT_S expander_phy[SML_MAX_EXPANDER_PER_CONTROLLER];
    PHY_ERR_MOCK_INFO_S expander_mock_mgnt_info[SML_MAX_EXPANDER_PER_CONTROLLER];
} STORAGE_DIAG_INFO_S;

typedef struct tag_pd_smart_test_analysis {
    SML_PD_FAULT_ANALYSIS *result;
    guint8 in_progress;
} PD_SMART_TEST_ANALYSIS;

#pragma pack()

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __DIAGNOSE_DEFS_H__ */
