/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#include "l_sml.h"

#include "l_callbacks.h"
#include "l_ctrl.h"
#include "l_ld.h"
#include "l_mctp_infos.h"
#include "l_pd.h"
#include "l_array.h"
#include "l_battery.h"
#include "l_phyerrorcode.h"

using namespace sml;

namespace {
LUA_EXPORT int luaopen_sml_core(lua_State *L)
{
    luaL_checkversion(L);

    luawrap::stack_table t = luawrap::stack::new_table(L);
    register_ctrl_oob::register_to(L, t);
    l_callbacks::register_to(L, t);
    l_mctp_infos::register_to(L, t);
    l_ctrl::register_to(L, t);
    l_pd::register_to(L, t);
    l_ld::register_to(L, t);
    l_ld::register_cache_to(L, t);
    l_array::register_to(L, t);
    l_battery::register_to(L, t);
    l_phyerrorcode::register_to(L, t);

    t.set("OOB_TYPE_OVER_I2C", OOB_TYPE_OVER_I2C);
    t.set("OOB_TYPE_OVER_PCIE", OOB_TYPE_OVER_PCIE);

    t.set("SML_ADD_CTRL", SML_ADD_CTRL);
    t.set("SML_REGISTER_CTRL", SML_REGISTER_CTRL);
    t.set("SML_DEL_CTRL", SML_DEL_CTRL);
    t.set("SML_UNREGISTER_CTRL", SML_UNREGISTER_CTRL);
    return 1;
}
}  // namespace
