/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_MCTP_INFO
#define L_SML_MCTP_INFO

#include "l_sml.h"

namespace sml {
struct mctp_info {
    uint8_t  eid;
    uint16_t phy_addr;
    uint16_t vendor_id;
};

class l_mctp_infos {
public:
    static void register_to(lua_State *L, luawrap::stack_table &t);

private:
    static void                          set_bmc_mctp_info(uint8_t bmc_eid, uint16_t bmc_phy_addr);
    static std::tuple<uint8_t, uint16_t> get_bmc_mctp_info();
    static void add_mctp_info(uint8_t controller_index, uint8_t eid, uint16_t phy_addr, uint16_t vendor_id);
    static void del_mctp_info(uint8_t controller_index);
    static void clean_mctp_info();
    static std::optional<std::tuple<uint16_t, uint16_t>> get_mctp_info(uint8_t controller_index);

    struct params {
        std::mutex               mutex;
        uint8_t                  bmc_eid;
        uint16_t                 bmc_phy_addr;
        std::map<int, mctp_info> mctp_infos;

        params() noexcept
        {
        }
    };
    static params s_params;
};

}  // namespace sml

#endif