-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local cmds = require 'hwproxy.plugins.sml.cmds'
local skynet = require 'skynet'
local log = require 'mc.logging'

local function run_cmd(wk_name, id, cmd, ...)
    if cmd == 'stop' then
        return false
    end

    skynet.send(id, wk_name, pcall(cmds[cmd], ...))
    return true
end

return function(work)
    local wk_id = tonumber(work:recv())
    local wk_name = work:recv()
    local id = tonumber(work:recv())
    local ok, err = pcall(skynet.register_protocol, {name = wk_name,
                                                     id = wk_id,
                                                     pack = skynet.pack,
                                                     unpack = skynet.tostring})
    if not ok then
        log:error('[Storage]work register failed: %s', err)
    end
    while true do
        ok, err = pcall(run_cmd, wk_name, id, skynet.unpack(work:recv()))
        if not ok then
            log:error('[Storage]work run failed: %s', err)
        end
    end
end
