-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Volume = {}

---@class Volume.MaxResizableSizeBytes
---@field MaxResizableSizeBytes integer
local TMaxResizableSizeBytes = {}
TMaxResizableSizeBytes.__index = TMaxResizableSizeBytes
TMaxResizableSizeBytes.group = {}

local function TMaxResizableSizeBytes_from_obj(obj)
    return setmetatable(obj, TMaxResizableSizeBytes)
end

function TMaxResizableSizeBytes.new(MaxResizableSizeBytes)
    return TMaxResizableSizeBytes_from_obj({MaxResizableSizeBytes = MaxResizableSizeBytes})
end
---@param obj Volume.MaxResizableSizeBytes
function TMaxResizableSizeBytes:init_from_obj(obj)
    self.MaxResizableSizeBytes = obj.MaxResizableSizeBytes
end

function TMaxResizableSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxResizableSizeBytes.group)
end

TMaxResizableSizeBytes.from_obj = TMaxResizableSizeBytes_from_obj

TMaxResizableSizeBytes.proto_property = {'MaxResizableSizeBytes'}

TMaxResizableSizeBytes.default = {0}

TMaxResizableSizeBytes.struct = {{name = 'MaxResizableSizeBytes', is_array = false, struct = nil}}

function TMaxResizableSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxResizableSizeBytes', self.MaxResizableSizeBytes, 'uint64', true, errs, need_convert)

    TMaxResizableSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxResizableSizeBytes.proto_property, errs, need_convert)
    return self
end

function TMaxResizableSizeBytes:unpack(_)
    return self.MaxResizableSizeBytes
end

Volume.MaxResizableSizeBytes = TMaxResizableSizeBytes

---@class Volume.SpanCount
---@field SpanCount integer
local TSpanCount = {}
TSpanCount.__index = TSpanCount
TSpanCount.group = {}

local function TSpanCount_from_obj(obj)
    return setmetatable(obj, TSpanCount)
end

function TSpanCount.new(SpanCount)
    return TSpanCount_from_obj({SpanCount = SpanCount})
end
---@param obj Volume.SpanCount
function TSpanCount:init_from_obj(obj)
    self.SpanCount = obj.SpanCount
end

function TSpanCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpanCount.group)
end

TSpanCount.from_obj = TSpanCount_from_obj

TSpanCount.proto_property = {'SpanCount'}

TSpanCount.default = {0}

TSpanCount.struct = {{name = 'SpanCount', is_array = false, struct = nil}}

function TSpanCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpanCount', self.SpanCount, 'uint8', true, errs, need_convert)

    TSpanCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpanCount.proto_property, errs, need_convert)
    return self
end

function TSpanCount:unpack(_)
    return self.SpanCount
end

Volume.SpanCount = TSpanCount

---@class Volume.HotSpareDriveList
---@field HotSpareDriveList string[]
local THotSpareDriveList = {}
THotSpareDriveList.__index = THotSpareDriveList
THotSpareDriveList.group = {}

local function THotSpareDriveList_from_obj(obj)
    return setmetatable(obj, THotSpareDriveList)
end

function THotSpareDriveList.new(HotSpareDriveList)
    return THotSpareDriveList_from_obj({HotSpareDriveList = HotSpareDriveList})
end
---@param obj Volume.HotSpareDriveList
function THotSpareDriveList:init_from_obj(obj)
    self.HotSpareDriveList = obj.HotSpareDriveList
end

function THotSpareDriveList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THotSpareDriveList.group)
end

THotSpareDriveList.from_obj = THotSpareDriveList_from_obj

THotSpareDriveList.proto_property = {'HotSpareDriveList'}

THotSpareDriveList.default = {{}}

THotSpareDriveList.struct = {{name = 'HotSpareDriveList', is_array = true, struct = nil}}

function THotSpareDriveList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'HotSpareDriveList', self.HotSpareDriveList, 'string', true, errs, need_convert)

    THotSpareDriveList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THotSpareDriveList.proto_property, errs, need_convert)
    return self
end

function THotSpareDriveList:unpack(_)
    return self.HotSpareDriveList
end

Volume.HotSpareDriveList = THotSpareDriveList

---@class Volume.RefDiskArrayList
---@field RefDiskArrayList integer[]
local TRefDiskArrayList = {}
TRefDiskArrayList.__index = TRefDiskArrayList
TRefDiskArrayList.group = {}

local function TRefDiskArrayList_from_obj(obj)
    return setmetatable(obj, TRefDiskArrayList)
end

function TRefDiskArrayList.new(RefDiskArrayList)
    return TRefDiskArrayList_from_obj({RefDiskArrayList = RefDiskArrayList})
end
---@param obj Volume.RefDiskArrayList
function TRefDiskArrayList:init_from_obj(obj)
    self.RefDiskArrayList = obj.RefDiskArrayList
end

function TRefDiskArrayList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefDiskArrayList.group)
end

TRefDiskArrayList.from_obj = TRefDiskArrayList_from_obj

TRefDiskArrayList.proto_property = {'RefDiskArrayList'}

TRefDiskArrayList.default = {{}}

TRefDiskArrayList.struct = {{name = 'RefDiskArrayList', is_array = true, struct = nil}}

function TRefDiskArrayList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefDiskArrayList', self.RefDiskArrayList, 'uint16', true, errs, need_convert)

    TRefDiskArrayList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefDiskArrayList.proto_property, errs, need_convert)
    return self
end

function TRefDiskArrayList:unpack(_)
    return self.RefDiskArrayList
end

Volume.RefDiskArrayList = TRefDiskArrayList

---@class Volume.RefDriveList
---@field RefDriveList string[]
local TRefDriveList = {}
TRefDriveList.__index = TRefDriveList
TRefDriveList.group = {}

local function TRefDriveList_from_obj(obj)
    return setmetatable(obj, TRefDriveList)
end

function TRefDriveList.new(RefDriveList)
    return TRefDriveList_from_obj({RefDriveList = RefDriveList})
end
---@param obj Volume.RefDriveList
function TRefDriveList:init_from_obj(obj)
    self.RefDriveList = obj.RefDriveList
end

function TRefDriveList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefDriveList.group)
end

TRefDriveList.from_obj = TRefDriveList_from_obj

TRefDriveList.proto_property = {'RefDriveList'}

TRefDriveList.default = {{}}

TRefDriveList.struct = {{name = 'RefDriveList', is_array = true, struct = nil}}

function TRefDriveList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefDriveList', self.RefDriveList, 'string', true, errs, need_convert)

    TRefDriveList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefDriveList.proto_property, errs, need_convert)
    return self
end

function TRefDriveList:unpack(_)
    return self.RefDriveList
end

Volume.RefDriveList = TRefDriveList

---@class Volume.RefControllerId
---@field RefControllerId integer
local TRefControllerId = {}
TRefControllerId.__index = TRefControllerId
TRefControllerId.group = {}

local function TRefControllerId_from_obj(obj)
    return setmetatable(obj, TRefControllerId)
end

function TRefControllerId.new(RefControllerId)
    return TRefControllerId_from_obj({RefControllerId = RefControllerId})
end
---@param obj Volume.RefControllerId
function TRefControllerId:init_from_obj(obj)
    self.RefControllerId = obj.RefControllerId
end

function TRefControllerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerId.group)
end

TRefControllerId.from_obj = TRefControllerId_from_obj

TRefControllerId.proto_property = {'RefControllerId'}

TRefControllerId.default = {0}

TRefControllerId.struct = {{name = 'RefControllerId', is_array = false, struct = nil}}

function TRefControllerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RefControllerId', self.RefControllerId, 'uint8', true, errs, need_convert)

    TRefControllerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerId.proto_property, errs, need_convert)
    return self
end

function TRefControllerId:unpack(_)
    return self.RefControllerId
end

Volume.RefControllerId = TRefControllerId

---@class Volume.RebuildState
---@field RebuildState integer
local TRebuildState = {}
TRebuildState.__index = TRebuildState
TRebuildState.group = {}

local function TRebuildState_from_obj(obj)
    return setmetatable(obj, TRebuildState)
end

function TRebuildState.new(RebuildState)
    return TRebuildState_from_obj({RebuildState = RebuildState})
end
---@param obj Volume.RebuildState
function TRebuildState:init_from_obj(obj)
    self.RebuildState = obj.RebuildState
end

function TRebuildState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRebuildState.group)
end

TRebuildState.from_obj = TRebuildState_from_obj

TRebuildState.proto_property = {'RebuildState'}

TRebuildState.default = {0}

TRebuildState.struct = {{name = 'RebuildState', is_array = false, struct = nil}}

function TRebuildState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RebuildState', self.RebuildState, 'uint8', true, errs, need_convert)

    TRebuildState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRebuildState.proto_property, errs, need_convert)
    return self
end

function TRebuildState:unpack(_)
    return self.RebuildState
end

Volume.RebuildState = TRebuildState

---@class Volume.InitializationMode
---@field InitializationMode integer
local TInitializationMode = {}
TInitializationMode.__index = TInitializationMode
TInitializationMode.group = {}

local function TInitializationMode_from_obj(obj)
    return setmetatable(obj, TInitializationMode)
end

function TInitializationMode.new(InitializationMode)
    return TInitializationMode_from_obj({InitializationMode = InitializationMode})
end
---@param obj Volume.InitializationMode
function TInitializationMode:init_from_obj(obj)
    self.InitializationMode = obj.InitializationMode
end

function TInitializationMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitializationMode.group)
end

TInitializationMode.from_obj = TInitializationMode_from_obj

TInitializationMode.proto_property = {'InitializationMode'}

TInitializationMode.default = {0}

TInitializationMode.struct = {{name = 'InitializationMode', is_array = false, struct = nil}}

function TInitializationMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InitializationMode', self.InitializationMode, 'uint8', true, errs, need_convert)

    TInitializationMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitializationMode.proto_property, errs, need_convert)
    return self
end

function TInitializationMode:unpack(_)
    return self.InitializationMode
end

Volume.InitializationMode = TInitializationMode

---@class Volume.RebuildProgress
---@field RebuildProgress integer
local TRebuildProgress = {}
TRebuildProgress.__index = TRebuildProgress
TRebuildProgress.group = {}

local function TRebuildProgress_from_obj(obj)
    return setmetatable(obj, TRebuildProgress)
end

function TRebuildProgress.new(RebuildProgress)
    return TRebuildProgress_from_obj({RebuildProgress = RebuildProgress})
end
---@param obj Volume.RebuildProgress
function TRebuildProgress:init_from_obj(obj)
    self.RebuildProgress = obj.RebuildProgress
end

function TRebuildProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRebuildProgress.group)
end

TRebuildProgress.from_obj = TRebuildProgress_from_obj

TRebuildProgress.proto_property = {'RebuildProgress'}

TRebuildProgress.default = {0}

TRebuildProgress.struct = {{name = 'RebuildProgress', is_array = false, struct = nil}}

function TRebuildProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RebuildProgress', self.RebuildProgress, 'uint8', true, errs, need_convert)

    TRebuildProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRebuildProgress.proto_property, errs, need_convert)
    return self
end

function TRebuildProgress:unpack(_)
    return self.RebuildProgress
end

Volume.RebuildProgress = TRebuildProgress

---@class Volume.AccelerationMethod
---@field AccelerationMethod string
local TAccelerationMethod = {}
TAccelerationMethod.__index = TAccelerationMethod
TAccelerationMethod.group = {}

local function TAccelerationMethod_from_obj(obj)
    return setmetatable(obj, TAccelerationMethod)
end

function TAccelerationMethod.new(AccelerationMethod)
    return TAccelerationMethod_from_obj({AccelerationMethod = AccelerationMethod})
end
---@param obj Volume.AccelerationMethod
function TAccelerationMethod:init_from_obj(obj)
    self.AccelerationMethod = obj.AccelerationMethod
end

function TAccelerationMethod:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccelerationMethod.group)
end

TAccelerationMethod.from_obj = TAccelerationMethod_from_obj

TAccelerationMethod.proto_property = {'AccelerationMethod'}

TAccelerationMethod.default = {''}

TAccelerationMethod.struct = {{name = 'AccelerationMethod', is_array = false, struct = nil}}

function TAccelerationMethod:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccelerationMethod', self.AccelerationMethod, 'string', true, errs, need_convert)

    TAccelerationMethod:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccelerationMethod.proto_property, errs, need_convert)
    return self
end

function TAccelerationMethod:unpack(_)
    return self.AccelerationMethod
end

Volume.AccelerationMethod = TAccelerationMethod

---@class Volume.CacheLineSizeKiB
---@field CacheLineSizeKiB integer
local TCacheLineSizeKiB = {}
TCacheLineSizeKiB.__index = TCacheLineSizeKiB
TCacheLineSizeKiB.group = {}

local function TCacheLineSizeKiB_from_obj(obj)
    return setmetatable(obj, TCacheLineSizeKiB)
end

function TCacheLineSizeKiB.new(CacheLineSizeKiB)
    return TCacheLineSizeKiB_from_obj({CacheLineSizeKiB = CacheLineSizeKiB})
end
---@param obj Volume.CacheLineSizeKiB
function TCacheLineSizeKiB:init_from_obj(obj)
    self.CacheLineSizeKiB = obj.CacheLineSizeKiB
end

function TCacheLineSizeKiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCacheLineSizeKiB.group)
end

TCacheLineSizeKiB.from_obj = TCacheLineSizeKiB_from_obj

TCacheLineSizeKiB.proto_property = {'CacheLineSizeKiB'}

TCacheLineSizeKiB.default = {0}

TCacheLineSizeKiB.struct = {{name = 'CacheLineSizeKiB', is_array = false, struct = nil}}

function TCacheLineSizeKiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CacheLineSizeKiB', self.CacheLineSizeKiB, 'uint8', true, errs, need_convert)

    TCacheLineSizeKiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCacheLineSizeKiB.proto_property, errs, need_convert)
    return self
end

function TCacheLineSizeKiB:unpack(_)
    return self.CacheLineSizeKiB
end

Volume.CacheLineSizeKiB = TCacheLineSizeKiB

---@class Volume.CurrentCachePolicy
---@field CurrentCachePolicy string
local TCurrentCachePolicy = {}
TCurrentCachePolicy.__index = TCurrentCachePolicy
TCurrentCachePolicy.group = {}

local function TCurrentCachePolicy_from_obj(obj)
    return setmetatable(obj, TCurrentCachePolicy)
end

function TCurrentCachePolicy.new(CurrentCachePolicy)
    return TCurrentCachePolicy_from_obj({CurrentCachePolicy = CurrentCachePolicy})
end
---@param obj Volume.CurrentCachePolicy
function TCurrentCachePolicy:init_from_obj(obj)
    self.CurrentCachePolicy = obj.CurrentCachePolicy
end

function TCurrentCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentCachePolicy.group)
end

TCurrentCachePolicy.from_obj = TCurrentCachePolicy_from_obj

TCurrentCachePolicy.proto_property = {'CurrentCachePolicy'}

TCurrentCachePolicy.default = {''}

TCurrentCachePolicy.struct = {{name = 'CurrentCachePolicy', is_array = false, struct = nil}}

function TCurrentCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentCachePolicy', self.CurrentCachePolicy, 'string', true, errs, need_convert)

    TCurrentCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentCachePolicy.proto_property, errs, need_convert)
    return self
end

function TCurrentCachePolicy:unpack(_)
    return self.CurrentCachePolicy
end

Volume.CurrentCachePolicy = TCurrentCachePolicy

---@class Volume.AccessPolicy
---@field AccessPolicy string
local TAccessPolicy = {}
TAccessPolicy.__index = TAccessPolicy
TAccessPolicy.group = {}

local function TAccessPolicy_from_obj(obj)
    return setmetatable(obj, TAccessPolicy)
end

function TAccessPolicy.new(AccessPolicy)
    return TAccessPolicy_from_obj({AccessPolicy = AccessPolicy})
end
---@param obj Volume.AccessPolicy
function TAccessPolicy:init_from_obj(obj)
    self.AccessPolicy = obj.AccessPolicy
end

function TAccessPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccessPolicy.group)
end

TAccessPolicy.from_obj = TAccessPolicy_from_obj

TAccessPolicy.proto_property = {'AccessPolicy'}

TAccessPolicy.default = {''}

TAccessPolicy.struct = {{name = 'AccessPolicy', is_array = false, struct = nil}}

function TAccessPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccessPolicy', self.AccessPolicy, 'string', true, errs, need_convert)

    TAccessPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccessPolicy.proto_property, errs, need_convert)
    return self
end

function TAccessPolicy:unpack(_)
    return self.AccessPolicy
end

Volume.AccessPolicy = TAccessPolicy

---@class Volume.DefaultCachePolicy
---@field DefaultCachePolicy string
local TDefaultCachePolicy = {}
TDefaultCachePolicy.__index = TDefaultCachePolicy
TDefaultCachePolicy.group = {}

local function TDefaultCachePolicy_from_obj(obj)
    return setmetatable(obj, TDefaultCachePolicy)
end

function TDefaultCachePolicy.new(DefaultCachePolicy)
    return TDefaultCachePolicy_from_obj({DefaultCachePolicy = DefaultCachePolicy})
end
---@param obj Volume.DefaultCachePolicy
function TDefaultCachePolicy:init_from_obj(obj)
    self.DefaultCachePolicy = obj.DefaultCachePolicy
end

function TDefaultCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultCachePolicy.group)
end

TDefaultCachePolicy.from_obj = TDefaultCachePolicy_from_obj

TDefaultCachePolicy.proto_property = {'DefaultCachePolicy'}

TDefaultCachePolicy.default = {''}

TDefaultCachePolicy.struct = {{name = 'DefaultCachePolicy', is_array = false, struct = nil}}

function TDefaultCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultCachePolicy', self.DefaultCachePolicy, 'string', true, errs, need_convert)

    TDefaultCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultCachePolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultCachePolicy:unpack(_)
    return self.DefaultCachePolicy
end

Volume.DefaultCachePolicy = TDefaultCachePolicy

---@class Volume.AssociatedCacheCadeVolume
---@field AssociatedCacheCadeVolume integer[]
local TAssociatedCacheCadeVolume = {}
TAssociatedCacheCadeVolume.__index = TAssociatedCacheCadeVolume
TAssociatedCacheCadeVolume.group = {}

local function TAssociatedCacheCadeVolume_from_obj(obj)
    return setmetatable(obj, TAssociatedCacheCadeVolume)
end

function TAssociatedCacheCadeVolume.new(AssociatedCacheCadeVolume)
    return TAssociatedCacheCadeVolume_from_obj({AssociatedCacheCadeVolume = AssociatedCacheCadeVolume})
end
---@param obj Volume.AssociatedCacheCadeVolume
function TAssociatedCacheCadeVolume:init_from_obj(obj)
    self.AssociatedCacheCadeVolume = obj.AssociatedCacheCadeVolume
end

function TAssociatedCacheCadeVolume:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssociatedCacheCadeVolume.group)
end

TAssociatedCacheCadeVolume.from_obj = TAssociatedCacheCadeVolume_from_obj

TAssociatedCacheCadeVolume.proto_property = {'AssociatedCacheCadeVolume'}

TAssociatedCacheCadeVolume.default = {{}}

TAssociatedCacheCadeVolume.struct = {{name = 'AssociatedCacheCadeVolume', is_array = true, struct = nil}}

function TAssociatedCacheCadeVolume:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AssociatedCacheCadeVolume', self.AssociatedCacheCadeVolume, 'uint16', true, errs,
        need_convert)

    TAssociatedCacheCadeVolume:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssociatedCacheCadeVolume.proto_property, errs, need_convert)
    return self
end

function TAssociatedCacheCadeVolume:unpack(_)
    return self.AssociatedCacheCadeVolume
end

Volume.AssociatedCacheCadeVolume = TAssociatedCacheCadeVolume

---@class Volume.AssociatedVolumes
---@field AssociatedVolumes integer[]
local TAssociatedVolumes = {}
TAssociatedVolumes.__index = TAssociatedVolumes
TAssociatedVolumes.group = {}

local function TAssociatedVolumes_from_obj(obj)
    return setmetatable(obj, TAssociatedVolumes)
end

function TAssociatedVolumes.new(AssociatedVolumes)
    return TAssociatedVolumes_from_obj({AssociatedVolumes = AssociatedVolumes})
end
---@param obj Volume.AssociatedVolumes
function TAssociatedVolumes:init_from_obj(obj)
    self.AssociatedVolumes = obj.AssociatedVolumes
end

function TAssociatedVolumes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssociatedVolumes.group)
end

TAssociatedVolumes.from_obj = TAssociatedVolumes_from_obj

TAssociatedVolumes.proto_property = {'AssociatedVolumes'}

TAssociatedVolumes.default = {{}}

TAssociatedVolumes.struct = {{name = 'AssociatedVolumes', is_array = true, struct = nil}}

function TAssociatedVolumes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AssociatedVolumes', self.AssociatedVolumes, 'uint16', true, errs, need_convert)

    TAssociatedVolumes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssociatedVolumes.proto_property, errs, need_convert)
    return self
end

function TAssociatedVolumes:unpack(_)
    return self.AssociatedVolumes
end

Volume.AssociatedVolumes = TAssociatedVolumes

---@class Volume.SSDCachingEnable
---@field SSDCachingEnable integer
local TSSDCachingEnable = {}
TSSDCachingEnable.__index = TSSDCachingEnable
TSSDCachingEnable.group = {}

local function TSSDCachingEnable_from_obj(obj)
    return setmetatable(obj, TSSDCachingEnable)
end

function TSSDCachingEnable.new(SSDCachingEnable)
    return TSSDCachingEnable_from_obj({SSDCachingEnable = SSDCachingEnable})
end
---@param obj Volume.SSDCachingEnable
function TSSDCachingEnable:init_from_obj(obj)
    self.SSDCachingEnable = obj.SSDCachingEnable
end

function TSSDCachingEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSSDCachingEnable.group)
end

TSSDCachingEnable.from_obj = TSSDCachingEnable_from_obj

TSSDCachingEnable.proto_property = {'SSDCachingEnable'}

TSSDCachingEnable.default = {0}

TSSDCachingEnable.struct = {{name = 'SSDCachingEnable', is_array = false, struct = nil}}

function TSSDCachingEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SSDCachingEnable', self.SSDCachingEnable, 'uint8', true, errs, need_convert)

    TSSDCachingEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSSDCachingEnable.proto_property, errs, need_convert)
    return self
end

function TSSDCachingEnable:unpack(_)
    return self.SSDCachingEnable
end

Volume.SSDCachingEnable = TSSDCachingEnable

---@class Volume.ConsistencyCheck
---@field ConsistencyCheck integer
local TConsistencyCheck = {}
TConsistencyCheck.__index = TConsistencyCheck
TConsistencyCheck.group = {}

local function TConsistencyCheck_from_obj(obj)
    return setmetatable(obj, TConsistencyCheck)
end

function TConsistencyCheck.new(ConsistencyCheck)
    return TConsistencyCheck_from_obj({ConsistencyCheck = ConsistencyCheck})
end
---@param obj Volume.ConsistencyCheck
function TConsistencyCheck:init_from_obj(obj)
    self.ConsistencyCheck = obj.ConsistencyCheck
end

function TConsistencyCheck:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConsistencyCheck.group)
end

TConsistencyCheck.from_obj = TConsistencyCheck_from_obj

TConsistencyCheck.proto_property = {'ConsistencyCheck'}

TConsistencyCheck.default = {0}

TConsistencyCheck.struct = {{name = 'ConsistencyCheck', is_array = false, struct = nil}}

function TConsistencyCheck:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConsistencyCheck', self.ConsistencyCheck, 'uint8', true, errs, need_convert)

    TConsistencyCheck:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConsistencyCheck.proto_property, errs, need_convert)
    return self
end

function TConsistencyCheck:unpack(_)
    return self.ConsistencyCheck
end

Volume.ConsistencyCheck = TConsistencyCheck

---@class Volume.SSDCachecadeVolume
---@field SSDCachecadeVolume integer
local TSSDCachecadeVolume = {}
TSSDCachecadeVolume.__index = TSSDCachecadeVolume
TSSDCachecadeVolume.group = {}

local function TSSDCachecadeVolume_from_obj(obj)
    return setmetatable(obj, TSSDCachecadeVolume)
end

function TSSDCachecadeVolume.new(SSDCachecadeVolume)
    return TSSDCachecadeVolume_from_obj({SSDCachecadeVolume = SSDCachecadeVolume})
end
---@param obj Volume.SSDCachecadeVolume
function TSSDCachecadeVolume:init_from_obj(obj)
    self.SSDCachecadeVolume = obj.SSDCachecadeVolume
end

function TSSDCachecadeVolume:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSSDCachecadeVolume.group)
end

TSSDCachecadeVolume.from_obj = TSSDCachecadeVolume_from_obj

TSSDCachecadeVolume.proto_property = {'SSDCachecadeVolume'}

TSSDCachecadeVolume.default = {0}

TSSDCachecadeVolume.struct = {{name = 'SSDCachecadeVolume', is_array = false, struct = nil}}

function TSSDCachecadeVolume:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SSDCachecadeVolume', self.SSDCachecadeVolume, 'uint8', true, errs, need_convert)

    TSSDCachecadeVolume:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSSDCachecadeVolume.proto_property, errs, need_convert)
    return self
end

function TSSDCachecadeVolume:unpack(_)
    return self.SSDCachecadeVolume
end

Volume.SSDCachecadeVolume = TSSDCachecadeVolume

---@class Volume.BGIEnable
---@field BGIEnable integer
local TBGIEnable = {}
TBGIEnable.__index = TBGIEnable
TBGIEnable.group = {}

local function TBGIEnable_from_obj(obj)
    return setmetatable(obj, TBGIEnable)
end

function TBGIEnable.new(BGIEnable)
    return TBGIEnable_from_obj({BGIEnable = BGIEnable})
end
---@param obj Volume.BGIEnable
function TBGIEnable:init_from_obj(obj)
    self.BGIEnable = obj.BGIEnable
end

function TBGIEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBGIEnable.group)
end

TBGIEnable.from_obj = TBGIEnable_from_obj

TBGIEnable.proto_property = {'BGIEnable'}

TBGIEnable.default = {0}

TBGIEnable.struct = {{name = 'BGIEnable', is_array = false, struct = nil}}

function TBGIEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BGIEnable', self.BGIEnable, 'uint8', true, errs, need_convert)

    TBGIEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBGIEnable.proto_property, errs, need_convert)
    return self
end

function TBGIEnable:unpack(_)
    return self.BGIEnable
end

Volume.BGIEnable = TBGIEnable

---@class Volume.OSDriveName
---@field OSDriveName string
local TOSDriveName = {}
TOSDriveName.__index = TOSDriveName
TOSDriveName.group = {}

local function TOSDriveName_from_obj(obj)
    return setmetatable(obj, TOSDriveName)
end

function TOSDriveName.new(OSDriveName)
    return TOSDriveName_from_obj({OSDriveName = OSDriveName})
end
---@param obj Volume.OSDriveName
function TOSDriveName:init_from_obj(obj)
    self.OSDriveName = obj.OSDriveName
end

function TOSDriveName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSDriveName.group)
end

TOSDriveName.from_obj = TOSDriveName_from_obj

TOSDriveName.proto_property = {'OSDriveName'}

TOSDriveName.default = {''}

TOSDriveName.struct = {{name = 'OSDriveName', is_array = false, struct = nil}}

function TOSDriveName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSDriveName', self.OSDriveName, 'string', true, errs, need_convert)

    TOSDriveName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSDriveName.proto_property, errs, need_convert)
    return self
end

function TOSDriveName:unpack(_)
    return self.OSDriveName
end

Volume.OSDriveName = TOSDriveName

---@class Volume.BootEnable
---@field BootEnable integer
local TBootEnable = {}
TBootEnable.__index = TBootEnable
TBootEnable.group = {}

local function TBootEnable_from_obj(obj)
    return setmetatable(obj, TBootEnable)
end

function TBootEnable.new(BootEnable)
    return TBootEnable_from_obj({BootEnable = BootEnable})
end
---@param obj Volume.BootEnable
function TBootEnable:init_from_obj(obj)
    self.BootEnable = obj.BootEnable
end

function TBootEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootEnable.group)
end

TBootEnable.from_obj = TBootEnable_from_obj

TBootEnable.proto_property = {'BootEnable'}

TBootEnable.default = {0}

TBootEnable.struct = {{name = 'BootEnable', is_array = false, struct = nil}}

function TBootEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootEnable', self.BootEnable, 'uint8', true, errs, need_convert)

    TBootEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootEnable.proto_property, errs, need_convert)
    return self
end

function TBootEnable:unpack(_)
    return self.BootEnable
end

Volume.BootEnable = TBootEnable

---@class Volume.BootPriority
---@field BootPriority integer
local TBootPriority = {}
TBootPriority.__index = TBootPriority
TBootPriority.group = {}

local function TBootPriority_from_obj(obj)
    return setmetatable(obj, TBootPriority)
end

function TBootPriority.new(BootPriority)
    return TBootPriority_from_obj({BootPriority = BootPriority})
end
---@param obj Volume.BootPriority
function TBootPriority:init_from_obj(obj)
    self.BootPriority = obj.BootPriority
end

function TBootPriority:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootPriority.group)
end

TBootPriority.from_obj = TBootPriority_from_obj

TBootPriority.proto_property = {'BootPriority'}

TBootPriority.default = {0}

TBootPriority.struct = {{name = 'BootPriority', is_array = false, struct = nil}}

function TBootPriority:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootPriority', self.BootPriority, 'uint8', true, errs, need_convert)

    TBootPriority:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootPriority.proto_property, errs, need_convert)
    return self
end

function TBootPriority:unpack(_)
    return self.BootPriority
end

Volume.BootPriority = TBootPriority

---@class Volume.CurrentWritePolicy
---@field CurrentWritePolicy string
local TCurrentWritePolicy = {}
TCurrentWritePolicy.__index = TCurrentWritePolicy
TCurrentWritePolicy.group = {}

local function TCurrentWritePolicy_from_obj(obj)
    return setmetatable(obj, TCurrentWritePolicy)
end

function TCurrentWritePolicy.new(CurrentWritePolicy)
    return TCurrentWritePolicy_from_obj({CurrentWritePolicy = CurrentWritePolicy})
end
---@param obj Volume.CurrentWritePolicy
function TCurrentWritePolicy:init_from_obj(obj)
    self.CurrentWritePolicy = obj.CurrentWritePolicy
end

function TCurrentWritePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentWritePolicy.group)
end

TCurrentWritePolicy.from_obj = TCurrentWritePolicy_from_obj

TCurrentWritePolicy.proto_property = {'CurrentWritePolicy'}

TCurrentWritePolicy.default = {''}

TCurrentWritePolicy.struct = {{name = 'CurrentWritePolicy', is_array = false, struct = nil}}

function TCurrentWritePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentWritePolicy', self.CurrentWritePolicy, 'string', true, errs, need_convert)

    TCurrentWritePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentWritePolicy.proto_property, errs, need_convert)
    return self
end

function TCurrentWritePolicy:unpack(_)
    return self.CurrentWritePolicy
end

Volume.CurrentWritePolicy = TCurrentWritePolicy

---@class Volume.CurrentReadPolicy
---@field CurrentReadPolicy string
local TCurrentReadPolicy = {}
TCurrentReadPolicy.__index = TCurrentReadPolicy
TCurrentReadPolicy.group = {}

local function TCurrentReadPolicy_from_obj(obj)
    return setmetatable(obj, TCurrentReadPolicy)
end

function TCurrentReadPolicy.new(CurrentReadPolicy)
    return TCurrentReadPolicy_from_obj({CurrentReadPolicy = CurrentReadPolicy})
end
---@param obj Volume.CurrentReadPolicy
function TCurrentReadPolicy:init_from_obj(obj)
    self.CurrentReadPolicy = obj.CurrentReadPolicy
end

function TCurrentReadPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentReadPolicy.group)
end

TCurrentReadPolicy.from_obj = TCurrentReadPolicy_from_obj

TCurrentReadPolicy.proto_property = {'CurrentReadPolicy'}

TCurrentReadPolicy.default = {''}

TCurrentReadPolicy.struct = {{name = 'CurrentReadPolicy', is_array = false, struct = nil}}

function TCurrentReadPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentReadPolicy', self.CurrentReadPolicy, 'string', true, errs, need_convert)

    TCurrentReadPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentReadPolicy.proto_property, errs, need_convert)
    return self
end

function TCurrentReadPolicy:unpack(_)
    return self.CurrentReadPolicy
end

Volume.CurrentReadPolicy = TCurrentReadPolicy

---@class Volume.ForegroundInitProgress
---@field ForegroundInitProgress integer
local TForegroundInitProgress = {}
TForegroundInitProgress.__index = TForegroundInitProgress
TForegroundInitProgress.group = {}

local function TForegroundInitProgress_from_obj(obj)
    return setmetatable(obj, TForegroundInitProgress)
end

function TForegroundInitProgress.new(ForegroundInitProgress)
    return TForegroundInitProgress_from_obj({ForegroundInitProgress = ForegroundInitProgress})
end
---@param obj Volume.ForegroundInitProgress
function TForegroundInitProgress:init_from_obj(obj)
    self.ForegroundInitProgress = obj.ForegroundInitProgress
end

function TForegroundInitProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForegroundInitProgress.group)
end

TForegroundInitProgress.from_obj = TForegroundInitProgress_from_obj

TForegroundInitProgress.proto_property = {'ForegroundInitProgress'}

TForegroundInitProgress.default = {0}

TForegroundInitProgress.struct = {{name = 'ForegroundInitProgress', is_array = false, struct = nil}}

function TForegroundInitProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ForegroundInitProgress', self.ForegroundInitProgress, 'uint8', true, errs, need_convert)

    TForegroundInitProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForegroundInitProgress.proto_property, errs, need_convert)
    return self
end

function TForegroundInitProgress:unpack(_)
    return self.ForegroundInitProgress
end

Volume.ForegroundInitProgress = TForegroundInitProgress

---@class Volume.CurrentForegroundInitState
---@field CurrentForegroundInitState integer
local TCurrentForegroundInitState = {}
TCurrentForegroundInitState.__index = TCurrentForegroundInitState
TCurrentForegroundInitState.group = {}

local function TCurrentForegroundInitState_from_obj(obj)
    return setmetatable(obj, TCurrentForegroundInitState)
end

function TCurrentForegroundInitState.new(CurrentForegroundInitState)
    return TCurrentForegroundInitState_from_obj({CurrentForegroundInitState = CurrentForegroundInitState})
end
---@param obj Volume.CurrentForegroundInitState
function TCurrentForegroundInitState:init_from_obj(obj)
    self.CurrentForegroundInitState = obj.CurrentForegroundInitState
end

function TCurrentForegroundInitState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentForegroundInitState.group)
end

TCurrentForegroundInitState.from_obj = TCurrentForegroundInitState_from_obj

TCurrentForegroundInitState.proto_property = {'CurrentForegroundInitState'}

TCurrentForegroundInitState.default = {0}

TCurrentForegroundInitState.struct = {{name = 'CurrentForegroundInitState', is_array = false, struct = nil}}

function TCurrentForegroundInitState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentForegroundInitState', self.CurrentForegroundInitState, 'uint8', true, errs,
        need_convert)

    TCurrentForegroundInitState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentForegroundInitState.proto_property, errs, need_convert)
    return self
end

function TCurrentForegroundInitState:unpack(_)
    return self.CurrentForegroundInitState
end

Volume.CurrentForegroundInitState = TCurrentForegroundInitState

---@class Volume.DriveCachePolicy
---@field DriveCachePolicy integer
local TDriveCachePolicy = {}
TDriveCachePolicy.__index = TDriveCachePolicy
TDriveCachePolicy.group = {}

local function TDriveCachePolicy_from_obj(obj)
    return setmetatable(obj, TDriveCachePolicy)
end

function TDriveCachePolicy.new(DriveCachePolicy)
    return TDriveCachePolicy_from_obj({DriveCachePolicy = DriveCachePolicy})
end
---@param obj Volume.DriveCachePolicy
function TDriveCachePolicy:init_from_obj(obj)
    self.DriveCachePolicy = obj.DriveCachePolicy
end

function TDriveCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriveCachePolicy.group)
end

TDriveCachePolicy.from_obj = TDriveCachePolicy_from_obj

TDriveCachePolicy.proto_property = {'DriveCachePolicy'}

TDriveCachePolicy.default = {0}

TDriveCachePolicy.struct = {{name = 'DriveCachePolicy', is_array = false, struct = nil}}

function TDriveCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriveCachePolicy', self.DriveCachePolicy, 'uint8', true, errs, need_convert)

    TDriveCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriveCachePolicy.proto_property, errs, need_convert)
    return self
end

function TDriveCachePolicy:unpack(_)
    return self.DriveCachePolicy
end

Volume.DriveCachePolicy = TDriveCachePolicy

---@class Volume.CapacityBytes
---@field CapacityBytes integer
local TCapacityBytes = {}
TCapacityBytes.__index = TCapacityBytes
TCapacityBytes.group = {}

local function TCapacityBytes_from_obj(obj)
    return setmetatable(obj, TCapacityBytes)
end

function TCapacityBytes.new(CapacityBytes)
    return TCapacityBytes_from_obj({CapacityBytes = CapacityBytes})
end
---@param obj Volume.CapacityBytes
function TCapacityBytes:init_from_obj(obj)
    self.CapacityBytes = obj.CapacityBytes
end

function TCapacityBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapacityBytes.group)
end

TCapacityBytes.from_obj = TCapacityBytes_from_obj

TCapacityBytes.proto_property = {'CapacityBytes'}

TCapacityBytes.default = {0}

TCapacityBytes.struct = {{name = 'CapacityBytes', is_array = false, struct = nil}}

function TCapacityBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacityBytes', self.CapacityBytes, 'uint64', true, errs, need_convert)

    TCapacityBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapacityBytes.proto_property, errs, need_convert)
    return self
end

function TCapacityBytes:unpack(_)
    return self.CapacityBytes
end

Volume.CapacityBytes = TCapacityBytes

---@class Volume.RAIDType
---@field RAIDType integer
local TRAIDType = {}
TRAIDType.__index = TRAIDType
TRAIDType.group = {}

local function TRAIDType_from_obj(obj)
    return setmetatable(obj, TRAIDType)
end

function TRAIDType.new(RAIDType)
    return TRAIDType_from_obj({RAIDType = RAIDType})
end
---@param obj Volume.RAIDType
function TRAIDType:init_from_obj(obj)
    self.RAIDType = obj.RAIDType
end

function TRAIDType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRAIDType.group)
end

TRAIDType.from_obj = TRAIDType_from_obj

TRAIDType.proto_property = {'RAIDType'}

TRAIDType.default = {0}

TRAIDType.struct = {{name = 'RAIDType', is_array = false, struct = nil}}

function TRAIDType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RAIDType', self.RAIDType, 'uint8', true, errs, need_convert)

    TRAIDType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRAIDType.proto_property, errs, need_convert)
    return self
end

function TRAIDType:unpack(_)
    return self.RAIDType
end

Volume.RAIDType = TRAIDType

---@class Volume.State
---@field State integer
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State or 255})
end
---@param obj Volume.State
function TState:init_from_obj(obj)
    self.State = obj.State or 255
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {0}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', true, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

Volume.State = TState

---@class Volume.DefaultWritePolicy
---@field DefaultWritePolicy string
local TDefaultWritePolicy = {}
TDefaultWritePolicy.__index = TDefaultWritePolicy
TDefaultWritePolicy.group = {}

local function TDefaultWritePolicy_from_obj(obj)
    return setmetatable(obj, TDefaultWritePolicy)
end

function TDefaultWritePolicy.new(DefaultWritePolicy)
    return TDefaultWritePolicy_from_obj({DefaultWritePolicy = DefaultWritePolicy})
end
---@param obj Volume.DefaultWritePolicy
function TDefaultWritePolicy:init_from_obj(obj)
    self.DefaultWritePolicy = obj.DefaultWritePolicy
end

function TDefaultWritePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultWritePolicy.group)
end

TDefaultWritePolicy.from_obj = TDefaultWritePolicy_from_obj

TDefaultWritePolicy.proto_property = {'DefaultWritePolicy'}

TDefaultWritePolicy.default = {''}

TDefaultWritePolicy.struct = {{name = 'DefaultWritePolicy', is_array = false, struct = nil}}

function TDefaultWritePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultWritePolicy', self.DefaultWritePolicy, 'string', true, errs, need_convert)

    TDefaultWritePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultWritePolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultWritePolicy:unpack(_)
    return self.DefaultWritePolicy
end

Volume.DefaultWritePolicy = TDefaultWritePolicy

---@class Volume.DefaultReadPolicy
---@field DefaultReadPolicy string
local TDefaultReadPolicy = {}
TDefaultReadPolicy.__index = TDefaultReadPolicy
TDefaultReadPolicy.group = {}

local function TDefaultReadPolicy_from_obj(obj)
    return setmetatable(obj, TDefaultReadPolicy)
end

function TDefaultReadPolicy.new(DefaultReadPolicy)
    return TDefaultReadPolicy_from_obj({DefaultReadPolicy = DefaultReadPolicy})
end
---@param obj Volume.DefaultReadPolicy
function TDefaultReadPolicy:init_from_obj(obj)
    self.DefaultReadPolicy = obj.DefaultReadPolicy
end

function TDefaultReadPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultReadPolicy.group)
end

TDefaultReadPolicy.from_obj = TDefaultReadPolicy_from_obj

TDefaultReadPolicy.proto_property = {'DefaultReadPolicy'}

TDefaultReadPolicy.default = {''}

TDefaultReadPolicy.struct = {{name = 'DefaultReadPolicy', is_array = false, struct = nil}}

function TDefaultReadPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultReadPolicy', self.DefaultReadPolicy, 'string', true, errs, need_convert)

    TDefaultReadPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultReadPolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultReadPolicy:unpack(_)
    return self.DefaultReadPolicy
end

Volume.DefaultReadPolicy = TDefaultReadPolicy

---@class Volume.OptimumIOSizeBytes
---@field OptimumIOSizeBytes integer
local TOptimumIOSizeBytes = {}
TOptimumIOSizeBytes.__index = TOptimumIOSizeBytes
TOptimumIOSizeBytes.group = {}

local function TOptimumIOSizeBytes_from_obj(obj)
    return setmetatable(obj, TOptimumIOSizeBytes)
end

function TOptimumIOSizeBytes.new(OptimumIOSizeBytes)
    return TOptimumIOSizeBytes_from_obj({OptimumIOSizeBytes = OptimumIOSizeBytes})
end
---@param obj Volume.OptimumIOSizeBytes
function TOptimumIOSizeBytes:init_from_obj(obj)
    self.OptimumIOSizeBytes = obj.OptimumIOSizeBytes
end

function TOptimumIOSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOptimumIOSizeBytes.group)
end

TOptimumIOSizeBytes.from_obj = TOptimumIOSizeBytes_from_obj

TOptimumIOSizeBytes.proto_property = {'OptimumIOSizeBytes'}

TOptimumIOSizeBytes.default = {0}

TOptimumIOSizeBytes.struct = {{name = 'OptimumIOSizeBytes', is_array = false, struct = nil}}

function TOptimumIOSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OptimumIOSizeBytes', self.OptimumIOSizeBytes, 'uint32', true, errs, need_convert)

    TOptimumIOSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOptimumIOSizeBytes.proto_property, errs, need_convert)
    return self
end

function TOptimumIOSizeBytes:unpack(_)
    return self.OptimumIOSizeBytes
end

Volume.OptimumIOSizeBytes = TOptimumIOSizeBytes

---@class Volume.VolumeName
---@field VolumeName string
local TVolumeName = {}
TVolumeName.__index = TVolumeName
TVolumeName.group = {}

local function TVolumeName_from_obj(obj)
    return setmetatable(obj, TVolumeName)
end

function TVolumeName.new(VolumeName)
    return TVolumeName_from_obj({VolumeName = VolumeName})
end
---@param obj Volume.VolumeName
function TVolumeName:init_from_obj(obj)
    self.VolumeName = obj.VolumeName
end

function TVolumeName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVolumeName.group)
end

TVolumeName.from_obj = TVolumeName_from_obj

TVolumeName.proto_property = {'VolumeName'}

TVolumeName.default = {''}

TVolumeName.struct = {{name = 'VolumeName', is_array = false, struct = nil}}

function TVolumeName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VolumeName', self.VolumeName, 'string', true, errs, need_convert)

    TVolumeName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVolumeName.proto_property, errs, need_convert)
    return self
end

function TVolumeName:unpack(_)
    return self.VolumeName
end

Volume.VolumeName = TVolumeName

---@class Volume.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Volume.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint16', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Volume.Id = TId

---@class Volume.SetStripSizeRsp
local TSetStripSizeRsp = {}
TSetStripSizeRsp.__index = TSetStripSizeRsp
TSetStripSizeRsp.group = {}

local function TSetStripSizeRsp_from_obj(obj)
    return setmetatable(obj, TSetStripSizeRsp)
end

function TSetStripSizeRsp.new()
    return TSetStripSizeRsp_from_obj({})
end
---@param obj Volume.SetStripSizeRsp
function TSetStripSizeRsp:init_from_obj(obj)

end

function TSetStripSizeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStripSizeRsp.group)
end

TSetStripSizeRsp.from_obj = TSetStripSizeRsp_from_obj

TSetStripSizeRsp.proto_property = {}

TSetStripSizeRsp.default = {}

TSetStripSizeRsp.struct = {}

function TSetStripSizeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetStripSizeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStripSizeRsp.proto_property, errs, need_convert)
    return self
end

function TSetStripSizeRsp:unpack(_)
end

Volume.SetStripSizeRsp = TSetStripSizeRsp

---@class Volume.SetStripSizeReq
---@field StripSize integer
local TSetStripSizeReq = {}
TSetStripSizeReq.__index = TSetStripSizeReq
TSetStripSizeReq.group = {}

local function TSetStripSizeReq_from_obj(obj)
    return setmetatable(obj, TSetStripSizeReq)
end

function TSetStripSizeReq.new(StripSize)
    return TSetStripSizeReq_from_obj({StripSize = StripSize})
end
---@param obj Volume.SetStripSizeReq
function TSetStripSizeReq:init_from_obj(obj)
    self.StripSize = obj.StripSize
end

function TSetStripSizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStripSizeReq.group)
end

TSetStripSizeReq.from_obj = TSetStripSizeReq_from_obj

TSetStripSizeReq.proto_property = {'StripSize'}

TSetStripSizeReq.default = {0}

TSetStripSizeReq.struct = {{name = 'StripSize', is_array = false, struct = nil}}

function TSetStripSizeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StripSize', self.StripSize, 'uint8', false, errs, need_convert)

    TSetStripSizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStripSizeReq.proto_property, errs, need_convert)
    return self
end

function TSetStripSizeReq:unpack(_)
    return self.StripSize
end

Volume.SetStripSizeReq = TSetStripSizeReq

---@class Volume.SetCapacitySizeRsp
local TSetCapacitySizeRsp = {}
TSetCapacitySizeRsp.__index = TSetCapacitySizeRsp
TSetCapacitySizeRsp.group = {}

local function TSetCapacitySizeRsp_from_obj(obj)
    return setmetatable(obj, TSetCapacitySizeRsp)
end

function TSetCapacitySizeRsp.new()
    return TSetCapacitySizeRsp_from_obj({})
end
---@param obj Volume.SetCapacitySizeRsp
function TSetCapacitySizeRsp:init_from_obj(obj)

end

function TSetCapacitySizeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCapacitySizeRsp.group)
end

TSetCapacitySizeRsp.from_obj = TSetCapacitySizeRsp_from_obj

TSetCapacitySizeRsp.proto_property = {}

TSetCapacitySizeRsp.default = {}

TSetCapacitySizeRsp.struct = {}

function TSetCapacitySizeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCapacitySizeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCapacitySizeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCapacitySizeRsp:unpack(_)
end

Volume.SetCapacitySizeRsp = TSetCapacitySizeRsp

---@class Volume.SetCapacitySizeReq
---@field CapacitySize integer
---@field CapacityUnit integer
local TSetCapacitySizeReq = {}
TSetCapacitySizeReq.__index = TSetCapacitySizeReq
TSetCapacitySizeReq.group = {}

local function TSetCapacitySizeReq_from_obj(obj)
    return setmetatable(obj, TSetCapacitySizeReq)
end

function TSetCapacitySizeReq.new(CapacitySize, CapacityUnit)
    return TSetCapacitySizeReq_from_obj({CapacitySize = CapacitySize, CapacityUnit = CapacityUnit})
end
---@param obj Volume.SetCapacitySizeReq
function TSetCapacitySizeReq:init_from_obj(obj)
    self.CapacitySize = obj.CapacitySize
    self.CapacityUnit = obj.CapacityUnit
end

function TSetCapacitySizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCapacitySizeReq.group)
end

TSetCapacitySizeReq.from_obj = TSetCapacitySizeReq_from_obj

TSetCapacitySizeReq.proto_property = {'CapacitySize', 'CapacityUnit'}

TSetCapacitySizeReq.default = {0, 0}

TSetCapacitySizeReq.struct = {
    {name = 'CapacitySize', is_array = false, struct = nil}, {name = 'CapacityUnit', is_array = false, struct = nil}
}

function TSetCapacitySizeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacitySize', self.CapacitySize, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CapacityUnit', self.CapacityUnit, 'uint8', false, errs, need_convert)

    TSetCapacitySizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCapacitySizeReq.proto_property, errs, need_convert)
    return self
end

function TSetCapacitySizeReq:unpack(_)
    return self.CapacitySize, self.CapacityUnit
end

Volume.SetCapacitySizeReq = TSetCapacitySizeReq

---@class Volume.SetAcceleratorRsp
local TSetAcceleratorRsp = {}
TSetAcceleratorRsp.__index = TSetAcceleratorRsp
TSetAcceleratorRsp.group = {}

local function TSetAcceleratorRsp_from_obj(obj)
    return setmetatable(obj, TSetAcceleratorRsp)
end

function TSetAcceleratorRsp.new()
    return TSetAcceleratorRsp_from_obj({})
end
---@param obj Volume.SetAcceleratorRsp
function TSetAcceleratorRsp:init_from_obj(obj)

end

function TSetAcceleratorRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAcceleratorRsp.group)
end

TSetAcceleratorRsp.from_obj = TSetAcceleratorRsp_from_obj

TSetAcceleratorRsp.proto_property = {}

TSetAcceleratorRsp.default = {}

TSetAcceleratorRsp.struct = {}

function TSetAcceleratorRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAcceleratorRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAcceleratorRsp.proto_property, errs, need_convert)
    return self
end

function TSetAcceleratorRsp:unpack(_)
end

Volume.SetAcceleratorRsp = TSetAcceleratorRsp

---@class Volume.SetAcceleratorReq
---@field Accelerator integer
local TSetAcceleratorReq = {}
TSetAcceleratorReq.__index = TSetAcceleratorReq
TSetAcceleratorReq.group = {}

local function TSetAcceleratorReq_from_obj(obj)
    return setmetatable(obj, TSetAcceleratorReq)
end

function TSetAcceleratorReq.new(Accelerator)
    return TSetAcceleratorReq_from_obj({Accelerator = Accelerator})
end
---@param obj Volume.SetAcceleratorReq
function TSetAcceleratorReq:init_from_obj(obj)
    self.Accelerator = obj.Accelerator
end

function TSetAcceleratorReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAcceleratorReq.group)
end

TSetAcceleratorReq.from_obj = TSetAcceleratorReq_from_obj

TSetAcceleratorReq.proto_property = {'Accelerator'}

TSetAcceleratorReq.default = {0}

TSetAcceleratorReq.struct = {{name = 'Accelerator', is_array = false, struct = nil}}

function TSetAcceleratorReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Accelerator', self.Accelerator, 'uint8', false, errs, need_convert)

    TSetAcceleratorReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAcceleratorReq.proto_property, errs, need_convert)
    return self
end

function TSetAcceleratorReq:unpack(_)
    return self.Accelerator
end

Volume.SetAcceleratorReq = TSetAcceleratorReq

---@class Volume.SetCachecadeEnableRsp
local TSetCachecadeEnableRsp = {}
TSetCachecadeEnableRsp.__index = TSetCachecadeEnableRsp
TSetCachecadeEnableRsp.group = {}

local function TSetCachecadeEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetCachecadeEnableRsp)
end

function TSetCachecadeEnableRsp.new()
    return TSetCachecadeEnableRsp_from_obj({})
end
---@param obj Volume.SetCachecadeEnableRsp
function TSetCachecadeEnableRsp:init_from_obj(obj)

end

function TSetCachecadeEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCachecadeEnableRsp.group)
end

TSetCachecadeEnableRsp.from_obj = TSetCachecadeEnableRsp_from_obj

TSetCachecadeEnableRsp.proto_property = {}

TSetCachecadeEnableRsp.default = {}

TSetCachecadeEnableRsp.struct = {}

function TSetCachecadeEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCachecadeEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCachecadeEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetCachecadeEnableRsp:unpack(_)
end

Volume.SetCachecadeEnableRsp = TSetCachecadeEnableRsp

---@class Volume.SetCachecadeEnableReq
---@field AssociateCachecade integer
local TSetCachecadeEnableReq = {}
TSetCachecadeEnableReq.__index = TSetCachecadeEnableReq
TSetCachecadeEnableReq.group = {}

local function TSetCachecadeEnableReq_from_obj(obj)
    return setmetatable(obj, TSetCachecadeEnableReq)
end

function TSetCachecadeEnableReq.new(AssociateCachecade)
    return TSetCachecadeEnableReq_from_obj({AssociateCachecade = AssociateCachecade})
end
---@param obj Volume.SetCachecadeEnableReq
function TSetCachecadeEnableReq:init_from_obj(obj)
    self.AssociateCachecade = obj.AssociateCachecade
end

function TSetCachecadeEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCachecadeEnableReq.group)
end

TSetCachecadeEnableReq.from_obj = TSetCachecadeEnableReq_from_obj

TSetCachecadeEnableReq.proto_property = {'AssociateCachecade'}

TSetCachecadeEnableReq.default = {0}

TSetCachecadeEnableReq.struct = {{name = 'AssociateCachecade', is_array = false, struct = nil}}

function TSetCachecadeEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssociateCachecade', self.AssociateCachecade, 'uint8', false, errs, need_convert)

    TSetCachecadeEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCachecadeEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetCachecadeEnableReq:unpack(_)
    return self.AssociateCachecade
end

Volume.SetCachecadeEnableReq = TSetCachecadeEnableReq

---@class Volume.CancelForegroundInitRsp
---@field TaskId integer
local TCancelForegroundInitRsp = {}
TCancelForegroundInitRsp.__index = TCancelForegroundInitRsp
TCancelForegroundInitRsp.group = {}

local function TCancelForegroundInitRsp_from_obj(obj)
    return setmetatable(obj, TCancelForegroundInitRsp)
end

function TCancelForegroundInitRsp.new(TaskId)
    return TCancelForegroundInitRsp_from_obj({TaskId = TaskId})
end
---@param obj Volume.CancelForegroundInitRsp
function TCancelForegroundInitRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCancelForegroundInitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCancelForegroundInitRsp.group)
end

TCancelForegroundInitRsp.from_obj = TCancelForegroundInitRsp_from_obj

TCancelForegroundInitRsp.proto_property = {'TaskId'}

TCancelForegroundInitRsp.default = {0}

TCancelForegroundInitRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCancelForegroundInitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCancelForegroundInitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCancelForegroundInitRsp.proto_property, errs, need_convert)
    return self
end

function TCancelForegroundInitRsp:unpack(_)
    return self.TaskId
end

Volume.CancelForegroundInitRsp = TCancelForegroundInitRsp

---@class Volume.CancelForegroundInitReq
local TCancelForegroundInitReq = {}
TCancelForegroundInitReq.__index = TCancelForegroundInitReq
TCancelForegroundInitReq.group = {}

local function TCancelForegroundInitReq_from_obj(obj)
    return setmetatable(obj, TCancelForegroundInitReq)
end

function TCancelForegroundInitReq.new()
    return TCancelForegroundInitReq_from_obj({})
end
---@param obj Volume.CancelForegroundInitReq
function TCancelForegroundInitReq:init_from_obj(obj)

end

function TCancelForegroundInitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCancelForegroundInitReq.group)
end

TCancelForegroundInitReq.from_obj = TCancelForegroundInitReq_from_obj

TCancelForegroundInitReq.proto_property = {}

TCancelForegroundInitReq.default = {}

TCancelForegroundInitReq.struct = {}

function TCancelForegroundInitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCancelForegroundInitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCancelForegroundInitReq.proto_property, errs, need_convert)
    return self
end

function TCancelForegroundInitReq:unpack(_)
end

Volume.CancelForegroundInitReq = TCancelForegroundInitReq

---@class Volume.StartForegroundInitRsp
---@field TaskId integer
local TStartForegroundInitRsp = {}
TStartForegroundInitRsp.__index = TStartForegroundInitRsp
TStartForegroundInitRsp.group = {}

local function TStartForegroundInitRsp_from_obj(obj)
    return setmetatable(obj, TStartForegroundInitRsp)
end

function TStartForegroundInitRsp.new(TaskId)
    return TStartForegroundInitRsp_from_obj({TaskId = TaskId})
end
---@param obj Volume.StartForegroundInitRsp
function TStartForegroundInitRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TStartForegroundInitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartForegroundInitRsp.group)
end

TStartForegroundInitRsp.from_obj = TStartForegroundInitRsp_from_obj

TStartForegroundInitRsp.proto_property = {'TaskId'}

TStartForegroundInitRsp.default = {0}

TStartForegroundInitRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TStartForegroundInitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TStartForegroundInitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartForegroundInitRsp.proto_property, errs, need_convert)
    return self
end

function TStartForegroundInitRsp:unpack(_)
    return self.TaskId
end

Volume.StartForegroundInitRsp = TStartForegroundInitRsp

---@class Volume.StartForegroundInitReq
---@field InitType integer
local TStartForegroundInitReq = {}
TStartForegroundInitReq.__index = TStartForegroundInitReq
TStartForegroundInitReq.group = {}

local function TStartForegroundInitReq_from_obj(obj)
    return setmetatable(obj, TStartForegroundInitReq)
end

function TStartForegroundInitReq.new(InitType)
    return TStartForegroundInitReq_from_obj({InitType = InitType})
end
---@param obj Volume.StartForegroundInitReq
function TStartForegroundInitReq:init_from_obj(obj)
    self.InitType = obj.InitType
end

function TStartForegroundInitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartForegroundInitReq.group)
end

TStartForegroundInitReq.from_obj = TStartForegroundInitReq_from_obj

TStartForegroundInitReq.proto_property = {'InitType'}

TStartForegroundInitReq.default = {0}

TStartForegroundInitReq.struct = {{name = 'InitType', is_array = false, struct = nil}}

function TStartForegroundInitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InitType', self.InitType, 'uint8', false, errs, need_convert)

    TStartForegroundInitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartForegroundInitReq.proto_property, errs, need_convert)
    return self
end

function TStartForegroundInitReq:unpack(_)
    return self.InitType
end

Volume.StartForegroundInitReq = TStartForegroundInitReq

---@class Volume.SetDiskCachePolicyRsp
local TSetDiskCachePolicyRsp = {}
TSetDiskCachePolicyRsp.__index = TSetDiskCachePolicyRsp
TSetDiskCachePolicyRsp.group = {}

local function TSetDiskCachePolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetDiskCachePolicyRsp)
end

function TSetDiskCachePolicyRsp.new()
    return TSetDiskCachePolicyRsp_from_obj({})
end
---@param obj Volume.SetDiskCachePolicyRsp
function TSetDiskCachePolicyRsp:init_from_obj(obj)

end

function TSetDiskCachePolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiskCachePolicyRsp.group)
end

TSetDiskCachePolicyRsp.from_obj = TSetDiskCachePolicyRsp_from_obj

TSetDiskCachePolicyRsp.proto_property = {}

TSetDiskCachePolicyRsp.default = {}

TSetDiskCachePolicyRsp.struct = {}

function TSetDiskCachePolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDiskCachePolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiskCachePolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetDiskCachePolicyRsp:unpack(_)
end

Volume.SetDiskCachePolicyRsp = TSetDiskCachePolicyRsp

---@class Volume.SetDiskCachePolicyReq
---@field DiskCachePolicy integer
local TSetDiskCachePolicyReq = {}
TSetDiskCachePolicyReq.__index = TSetDiskCachePolicyReq
TSetDiskCachePolicyReq.group = {}

local function TSetDiskCachePolicyReq_from_obj(obj)
    return setmetatable(obj, TSetDiskCachePolicyReq)
end

function TSetDiskCachePolicyReq.new(DiskCachePolicy)
    return TSetDiskCachePolicyReq_from_obj({DiskCachePolicy = DiskCachePolicy})
end
---@param obj Volume.SetDiskCachePolicyReq
function TSetDiskCachePolicyReq:init_from_obj(obj)
    self.DiskCachePolicy = obj.DiskCachePolicy
end

function TSetDiskCachePolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiskCachePolicyReq.group)
end

TSetDiskCachePolicyReq.from_obj = TSetDiskCachePolicyReq_from_obj

TSetDiskCachePolicyReq.proto_property = {'DiskCachePolicy'}

TSetDiskCachePolicyReq.default = {0}

TSetDiskCachePolicyReq.struct = {{name = 'DiskCachePolicy', is_array = false, struct = nil}}

function TSetDiskCachePolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskCachePolicy', self.DiskCachePolicy, 'uint8', false, errs, need_convert)

    TSetDiskCachePolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiskCachePolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetDiskCachePolicyReq:unpack(_)
    return self.DiskCachePolicy
end

Volume.SetDiskCachePolicyReq = TSetDiskCachePolicyReq

---@class Volume.SetAccessPolicyRsp
local TSetAccessPolicyRsp = {}
TSetAccessPolicyRsp.__index = TSetAccessPolicyRsp
TSetAccessPolicyRsp.group = {}

local function TSetAccessPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetAccessPolicyRsp)
end

function TSetAccessPolicyRsp.new()
    return TSetAccessPolicyRsp_from_obj({})
end
---@param obj Volume.SetAccessPolicyRsp
function TSetAccessPolicyRsp:init_from_obj(obj)

end

function TSetAccessPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessPolicyRsp.group)
end

TSetAccessPolicyRsp.from_obj = TSetAccessPolicyRsp_from_obj

TSetAccessPolicyRsp.proto_property = {}

TSetAccessPolicyRsp.default = {}

TSetAccessPolicyRsp.struct = {}

function TSetAccessPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAccessPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetAccessPolicyRsp:unpack(_)
end

Volume.SetAccessPolicyRsp = TSetAccessPolicyRsp

---@class Volume.SetAccessPolicyReq
---@field AccessPolicy integer
local TSetAccessPolicyReq = {}
TSetAccessPolicyReq.__index = TSetAccessPolicyReq
TSetAccessPolicyReq.group = {}

local function TSetAccessPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetAccessPolicyReq)
end

function TSetAccessPolicyReq.new(AccessPolicy)
    return TSetAccessPolicyReq_from_obj({AccessPolicy = AccessPolicy})
end
---@param obj Volume.SetAccessPolicyReq
function TSetAccessPolicyReq:init_from_obj(obj)
    self.AccessPolicy = obj.AccessPolicy
end

function TSetAccessPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessPolicyReq.group)
end

TSetAccessPolicyReq.from_obj = TSetAccessPolicyReq_from_obj

TSetAccessPolicyReq.proto_property = {'AccessPolicy'}

TSetAccessPolicyReq.default = {0}

TSetAccessPolicyReq.struct = {{name = 'AccessPolicy', is_array = false, struct = nil}}

function TSetAccessPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccessPolicy', self.AccessPolicy, 'uint8', false, errs, need_convert)

    TSetAccessPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetAccessPolicyReq:unpack(_)
    return self.AccessPolicy
end

Volume.SetAccessPolicyReq = TSetAccessPolicyReq

---@class Volume.SetBGIEnableRsp
local TSetBGIEnableRsp = {}
TSetBGIEnableRsp.__index = TSetBGIEnableRsp
TSetBGIEnableRsp.group = {}

local function TSetBGIEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetBGIEnableRsp)
end

function TSetBGIEnableRsp.new()
    return TSetBGIEnableRsp_from_obj({})
end
---@param obj Volume.SetBGIEnableRsp
function TSetBGIEnableRsp:init_from_obj(obj)

end

function TSetBGIEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBGIEnableRsp.group)
end

TSetBGIEnableRsp.from_obj = TSetBGIEnableRsp_from_obj

TSetBGIEnableRsp.proto_property = {}

TSetBGIEnableRsp.default = {}

TSetBGIEnableRsp.struct = {}

function TSetBGIEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBGIEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBGIEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetBGIEnableRsp:unpack(_)
end

Volume.SetBGIEnableRsp = TSetBGIEnableRsp

---@class Volume.SetBGIEnableReq
---@field BGIEnabled integer
local TSetBGIEnableReq = {}
TSetBGIEnableReq.__index = TSetBGIEnableReq
TSetBGIEnableReq.group = {}

local function TSetBGIEnableReq_from_obj(obj)
    return setmetatable(obj, TSetBGIEnableReq)
end

function TSetBGIEnableReq.new(BGIEnabled)
    return TSetBGIEnableReq_from_obj({BGIEnabled = BGIEnabled})
end
---@param obj Volume.SetBGIEnableReq
function TSetBGIEnableReq:init_from_obj(obj)
    self.BGIEnabled = obj.BGIEnabled
end

function TSetBGIEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBGIEnableReq.group)
end

TSetBGIEnableReq.from_obj = TSetBGIEnableReq_from_obj

TSetBGIEnableReq.proto_property = {'BGIEnabled'}

TSetBGIEnableReq.default = {0}

TSetBGIEnableReq.struct = {{name = 'BGIEnabled', is_array = false, struct = nil}}

function TSetBGIEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BGIEnabled', self.BGIEnabled, 'uint8', false, errs, need_convert)

    TSetBGIEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBGIEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetBGIEnableReq:unpack(_)
    return self.BGIEnabled
end

Volume.SetBGIEnableReq = TSetBGIEnableReq

---@class Volume.SetIOPolicyRsp
local TSetIOPolicyRsp = {}
TSetIOPolicyRsp.__index = TSetIOPolicyRsp
TSetIOPolicyRsp.group = {}

local function TSetIOPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetIOPolicyRsp)
end

function TSetIOPolicyRsp.new()
    return TSetIOPolicyRsp_from_obj({})
end
---@param obj Volume.SetIOPolicyRsp
function TSetIOPolicyRsp:init_from_obj(obj)

end

function TSetIOPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIOPolicyRsp.group)
end

TSetIOPolicyRsp.from_obj = TSetIOPolicyRsp_from_obj

TSetIOPolicyRsp.proto_property = {}

TSetIOPolicyRsp.default = {}

TSetIOPolicyRsp.struct = {}

function TSetIOPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetIOPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIOPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetIOPolicyRsp:unpack(_)
end

Volume.SetIOPolicyRsp = TSetIOPolicyRsp

---@class Volume.SetIOPolicyReq
---@field IOPolicy integer
local TSetIOPolicyReq = {}
TSetIOPolicyReq.__index = TSetIOPolicyReq
TSetIOPolicyReq.group = {}

local function TSetIOPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetIOPolicyReq)
end

function TSetIOPolicyReq.new(IOPolicy)
    return TSetIOPolicyReq_from_obj({IOPolicy = IOPolicy})
end
---@param obj Volume.SetIOPolicyReq
function TSetIOPolicyReq:init_from_obj(obj)
    self.IOPolicy = obj.IOPolicy
end

function TSetIOPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIOPolicyReq.group)
end

TSetIOPolicyReq.from_obj = TSetIOPolicyReq_from_obj

TSetIOPolicyReq.proto_property = {'IOPolicy'}

TSetIOPolicyReq.default = {0}

TSetIOPolicyReq.struct = {{name = 'IOPolicy', is_array = false, struct = nil}}

function TSetIOPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IOPolicy', self.IOPolicy, 'uint8', false, errs, need_convert)

    TSetIOPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIOPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetIOPolicyReq:unpack(_)
    return self.IOPolicy
end

Volume.SetIOPolicyReq = TSetIOPolicyReq

---@class Volume.SetBootableRsp
local TSetBootableRsp = {}
TSetBootableRsp.__index = TSetBootableRsp
TSetBootableRsp.group = {}

local function TSetBootableRsp_from_obj(obj)
    return setmetatable(obj, TSetBootableRsp)
end

function TSetBootableRsp.new()
    return TSetBootableRsp_from_obj({})
end
---@param obj Volume.SetBootableRsp
function TSetBootableRsp:init_from_obj(obj)

end

function TSetBootableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootableRsp.group)
end

TSetBootableRsp.from_obj = TSetBootableRsp_from_obj

TSetBootableRsp.proto_property = {}

TSetBootableRsp.default = {}

TSetBootableRsp.struct = {}

function TSetBootableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootableRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootableRsp:unpack(_)
end

Volume.SetBootableRsp = TSetBootableRsp

---@class Volume.SetBootableReq
---@field BootPriority integer
local TSetBootableReq = {}
TSetBootableReq.__index = TSetBootableReq
TSetBootableReq.group = {}

local function TSetBootableReq_from_obj(obj)
    return setmetatable(obj, TSetBootableReq)
end

function TSetBootableReq.new(BootPriority)
    return TSetBootableReq_from_obj({BootPriority = BootPriority})
end
---@param obj Volume.SetBootableReq
function TSetBootableReq:init_from_obj(obj)
    self.BootPriority = obj.BootPriority
end

function TSetBootableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootableReq.group)
end

TSetBootableReq.from_obj = TSetBootableReq_from_obj

TSetBootableReq.proto_property = {'BootPriority'}

TSetBootableReq.default = {0}

TSetBootableReq.struct = {{name = 'BootPriority', is_array = false, struct = nil}}

function TSetBootableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootPriority', self.BootPriority, 'uint8', false, errs, need_convert)

    TSetBootableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootableReq.proto_property, errs, need_convert)
    return self
end

function TSetBootableReq:unpack(_)
    return self.BootPriority
end

Volume.SetBootableReq = TSetBootableReq

---@class Volume.SetWritePolicyRsp
local TSetWritePolicyRsp = {}
TSetWritePolicyRsp.__index = TSetWritePolicyRsp
TSetWritePolicyRsp.group = {}

local function TSetWritePolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetWritePolicyRsp)
end

function TSetWritePolicyRsp.new()
    return TSetWritePolicyRsp_from_obj({})
end
---@param obj Volume.SetWritePolicyRsp
function TSetWritePolicyRsp:init_from_obj(obj)

end

function TSetWritePolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWritePolicyRsp.group)
end

TSetWritePolicyRsp.from_obj = TSetWritePolicyRsp_from_obj

TSetWritePolicyRsp.proto_property = {}

TSetWritePolicyRsp.default = {}

TSetWritePolicyRsp.struct = {}

function TSetWritePolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetWritePolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWritePolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetWritePolicyRsp:unpack(_)
end

Volume.SetWritePolicyRsp = TSetWritePolicyRsp

---@class Volume.SetWritePolicyReq
---@field WritePolicy integer
local TSetWritePolicyReq = {}
TSetWritePolicyReq.__index = TSetWritePolicyReq
TSetWritePolicyReq.group = {}

local function TSetWritePolicyReq_from_obj(obj)
    return setmetatable(obj, TSetWritePolicyReq)
end

function TSetWritePolicyReq.new(WritePolicy)
    return TSetWritePolicyReq_from_obj({WritePolicy = WritePolicy})
end
---@param obj Volume.SetWritePolicyReq
function TSetWritePolicyReq:init_from_obj(obj)
    self.WritePolicy = obj.WritePolicy
end

function TSetWritePolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWritePolicyReq.group)
end

TSetWritePolicyReq.from_obj = TSetWritePolicyReq_from_obj

TSetWritePolicyReq.proto_property = {'WritePolicy'}

TSetWritePolicyReq.default = {0}

TSetWritePolicyReq.struct = {{name = 'WritePolicy', is_array = false, struct = nil}}

function TSetWritePolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WritePolicy', self.WritePolicy, 'uint8', false, errs, need_convert)

    TSetWritePolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWritePolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetWritePolicyReq:unpack(_)
    return self.WritePolicy
end

Volume.SetWritePolicyReq = TSetWritePolicyReq

---@class Volume.SetReadPolicyRsp
local TSetReadPolicyRsp = {}
TSetReadPolicyRsp.__index = TSetReadPolicyRsp
TSetReadPolicyRsp.group = {}

local function TSetReadPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetReadPolicyRsp)
end

function TSetReadPolicyRsp.new()
    return TSetReadPolicyRsp_from_obj({})
end
---@param obj Volume.SetReadPolicyRsp
function TSetReadPolicyRsp:init_from_obj(obj)

end

function TSetReadPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetReadPolicyRsp.group)
end

TSetReadPolicyRsp.from_obj = TSetReadPolicyRsp_from_obj

TSetReadPolicyRsp.proto_property = {}

TSetReadPolicyRsp.default = {}

TSetReadPolicyRsp.struct = {}

function TSetReadPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetReadPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetReadPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetReadPolicyRsp:unpack(_)
end

Volume.SetReadPolicyRsp = TSetReadPolicyRsp

---@class Volume.SetReadPolicyReq
---@field ReadPolicy integer
local TSetReadPolicyReq = {}
TSetReadPolicyReq.__index = TSetReadPolicyReq
TSetReadPolicyReq.group = {}

local function TSetReadPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetReadPolicyReq)
end

function TSetReadPolicyReq.new(ReadPolicy)
    return TSetReadPolicyReq_from_obj({ReadPolicy = ReadPolicy})
end
---@param obj Volume.SetReadPolicyReq
function TSetReadPolicyReq:init_from_obj(obj)
    self.ReadPolicy = obj.ReadPolicy
end

function TSetReadPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetReadPolicyReq.group)
end

TSetReadPolicyReq.from_obj = TSetReadPolicyReq_from_obj

TSetReadPolicyReq.proto_property = {'ReadPolicy'}

TSetReadPolicyReq.default = {0}

TSetReadPolicyReq.struct = {{name = 'ReadPolicy', is_array = false, struct = nil}}

function TSetReadPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadPolicy', self.ReadPolicy, 'uint8', false, errs, need_convert)

    TSetReadPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetReadPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetReadPolicyReq:unpack(_)
    return self.ReadPolicy
end

Volume.SetReadPolicyReq = TSetReadPolicyReq

---@class Volume.SetNameRsp
local TSetNameRsp = {}
TSetNameRsp.__index = TSetNameRsp
TSetNameRsp.group = {}

local function TSetNameRsp_from_obj(obj)
    return setmetatable(obj, TSetNameRsp)
end

function TSetNameRsp.new()
    return TSetNameRsp_from_obj({})
end
---@param obj Volume.SetNameRsp
function TSetNameRsp:init_from_obj(obj)

end

function TSetNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNameRsp.group)
end

TSetNameRsp.from_obj = TSetNameRsp_from_obj

TSetNameRsp.proto_property = {}

TSetNameRsp.default = {}

TSetNameRsp.struct = {}

function TSetNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNameRsp.proto_property, errs, need_convert)
    return self
end

function TSetNameRsp:unpack(_)
end

Volume.SetNameRsp = TSetNameRsp

---@class Volume.SetNameReq
---@field Name string
local TSetNameReq = {}
TSetNameReq.__index = TSetNameReq
TSetNameReq.group = {}

local function TSetNameReq_from_obj(obj)
    return setmetatable(obj, TSetNameReq)
end

function TSetNameReq.new(Name)
    return TSetNameReq_from_obj({Name = Name})
end
---@param obj Volume.SetNameReq
function TSetNameReq:init_from_obj(obj)
    self.Name = obj.Name
end

function TSetNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNameReq.group)
end

TSetNameReq.from_obj = TSetNameReq_from_obj

TSetNameReq.proto_property = {'Name'}

TSetNameReq.default = {''}

TSetNameReq.struct = {{name = 'Name', is_array = false, struct = nil}}

function TSetNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TSetNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNameReq.proto_property, errs, need_convert)
    return self
end

function TSetNameReq:unpack(_)
    return self.Name
end

Volume.SetNameReq = TSetNameReq

Volume.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Volume', {
    Id = {'q', nil, true, nil},
    VolumeName = {'s', nil, true, nil},
    OptimumIOSizeBytes = {'u', nil, true, nil},
    DefaultReadPolicy = {'s', nil, true, nil},
    DefaultWritePolicy = {'s', nil, true, nil},
    State = {'y', nil, true, 255},
    RAIDType = {'y', nil, true, nil},
    CapacityBytes = {'t', nil, true, nil},
    DriveCachePolicy = {'y', nil, true, nil},
    CurrentForegroundInitState = {'y', nil, true, nil},
    ForegroundInitProgress = {'y', {'VOLATILE', 'EMIT_CHANGE'}, true, nil},
    CurrentReadPolicy = {'s', nil, true, nil},
    CurrentWritePolicy = {'s', nil, true, nil},
    BootPriority = {'y', nil, true, nil},
    BootEnable = {'y', nil, true, nil},
    OSDriveName = {'s', nil, true, nil},
    BGIEnable = {'y', nil, true, nil},
    SSDCachecadeVolume = {'y', nil, true, nil},
    ConsistencyCheck = {'y', nil, true, nil},
    SSDCachingEnable = {'y', nil, true, nil},
    AssociatedVolumes = {'aq', nil, true, nil},
    AssociatedCacheCadeVolume = {'aq', nil, true, nil},
    DefaultCachePolicy = {'s', nil, true, nil},
    AccessPolicy = {'s', nil, true, nil},
    CurrentCachePolicy = {'s', nil, true, nil},
    CacheLineSizeKiB = {'y', nil, true, nil},
    AccelerationMethod = {'s', nil, true, nil},
    RebuildProgress = {'y', nil, true, nil},
    InitializationMode = {'y', nil, true, nil},
    RebuildState = {'y', nil, true, nil},
    RefControllerId = {'y', nil, true, nil},
    RefDriveList = {'as', nil, true, nil},
    RefDiskArrayList = {'aq', nil, true, nil},
    HotSpareDriveList = {'as', nil, true, nil},
    SpanCount = {'y', nil, true, nil},
    MaxResizableSizeBytes = {'t', nil, true, nil}
}, {
    SetName = {'a{ss}s', '', TSetNameReq, TSetNameRsp},
    SetReadPolicy = {'a{ss}y', '', TSetReadPolicyReq, TSetReadPolicyRsp},
    SetWritePolicy = {'a{ss}y', '', TSetWritePolicyReq, TSetWritePolicyRsp},
    SetBootable = {'a{ss}y', '', TSetBootableReq, TSetBootableRsp},
    SetIOPolicy = {'a{ss}y', '', TSetIOPolicyReq, TSetIOPolicyRsp},
    SetBGIEnable = {'a{ss}y', '', TSetBGIEnableReq, TSetBGIEnableRsp},
    SetAccessPolicy = {'a{ss}y', '', TSetAccessPolicyReq, TSetAccessPolicyRsp},
    SetDiskCachePolicy = {'a{ss}y', '', TSetDiskCachePolicyReq, TSetDiskCachePolicyRsp},
    StartForegroundInit = {'a{ss}y', 'u', TStartForegroundInitReq, TStartForegroundInitRsp},
    CancelForegroundInit = {'a{ss}', 'u', TCancelForegroundInitReq, TCancelForegroundInitRsp},
    SetCachecadeEnable = {'a{ss}y', '', TSetCachecadeEnableReq, TSetCachecadeEnableRsp},
    SetAccelerator = {'a{ss}y', '', TSetAcceleratorReq, TSetAcceleratorRsp},
    SetCapacitySize = {'a{ss}uy', '', TSetCapacitySizeReq, TSetCapacitySizeRsp},
    SetStripSize = {'a{ss}y', '', TSetStripSizeReq, TSetStripSizeRsp}
}, {})

return Volume
