-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local StorageSetting = {}

---@class StorageSetting.SSDMediaLifeLeftPercentThreshold
---@field SSDMediaLifeLeftPercentThreshold integer
local TSSDMediaLifeLeftPercentThreshold = {}
TSSDMediaLifeLeftPercentThreshold.__index = TSSDMediaLifeLeftPercentThreshold
TSSDMediaLifeLeftPercentThreshold.group = {}

local function TSSDMediaLifeLeftPercentThreshold_from_obj(obj)
    return setmetatable(obj, TSSDMediaLifeLeftPercentThreshold)
end

function TSSDMediaLifeLeftPercentThreshold.new(SSDMediaLifeLeftPercentThreshold)
    return TSSDMediaLifeLeftPercentThreshold_from_obj({
        SSDMediaLifeLeftPercentThreshold = SSDMediaLifeLeftPercentThreshold or 5
    })
end
---@param obj StorageSetting.SSDMediaLifeLeftPercentThreshold
function TSSDMediaLifeLeftPercentThreshold:init_from_obj(obj)
    self.SSDMediaLifeLeftPercentThreshold = obj.SSDMediaLifeLeftPercentThreshold or 5
end

function TSSDMediaLifeLeftPercentThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSSDMediaLifeLeftPercentThreshold.group)
end

TSSDMediaLifeLeftPercentThreshold.from_obj = TSSDMediaLifeLeftPercentThreshold_from_obj

TSSDMediaLifeLeftPercentThreshold.proto_property = {'SSDMediaLifeLeftPercentThreshold'}

TSSDMediaLifeLeftPercentThreshold.default = {0}

TSSDMediaLifeLeftPercentThreshold.struct = {{name = 'SSDMediaLifeLeftPercentThreshold', is_array = false, struct = nil}}

function TSSDMediaLifeLeftPercentThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SSDMediaLifeLeftPercentThreshold', self.SSDMediaLifeLeftPercentThreshold, 'uint8',
        false, errs, need_convert)

    TSSDMediaLifeLeftPercentThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSSDMediaLifeLeftPercentThreshold.proto_property, errs, need_convert)
    return self
end

function TSSDMediaLifeLeftPercentThreshold:unpack(_)
    return self.SSDMediaLifeLeftPercentThreshold
end

StorageSetting.SSDMediaLifeLeftPercentThreshold = TSSDMediaLifeLeftPercentThreshold

StorageSetting.interface = mdb.register_interface('bmc.kepler.Chassis.Storage.StorageSetting', {
    SSDMediaLifeLeftPercentThreshold = {'y', {'EMIT_CHANGE'}, false, 5}
}, {}, {})

return StorageSetting
