-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SASMetrics = {}

---@class SASMetrics.RunningDisparityErrorCount
---@field RunningDisparityErrorCount integer
local TRunningDisparityErrorCount = {}
TRunningDisparityErrorCount.__index = TRunningDisparityErrorCount
TRunningDisparityErrorCount.group = {}

local function TRunningDisparityErrorCount_from_obj(obj)
    return setmetatable(obj, TRunningDisparityErrorCount)
end

function TRunningDisparityErrorCount.new(RunningDisparityErrorCount)
    return TRunningDisparityErrorCount_from_obj({RunningDisparityErrorCount = RunningDisparityErrorCount})
end
---@param obj SASMetrics.RunningDisparityErrorCount
function TRunningDisparityErrorCount:init_from_obj(obj)
    self.RunningDisparityErrorCount = obj.RunningDisparityErrorCount
end

function TRunningDisparityErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunningDisparityErrorCount.group)
end

TRunningDisparityErrorCount.from_obj = TRunningDisparityErrorCount_from_obj

TRunningDisparityErrorCount.proto_property = {'RunningDisparityErrorCount'}

TRunningDisparityErrorCount.default = {0}

TRunningDisparityErrorCount.struct = {{name = 'RunningDisparityErrorCount', is_array = false, struct = nil}}

function TRunningDisparityErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunningDisparityErrorCount', self.RunningDisparityErrorCount, 'uint32', true, errs,
        need_convert)

    TRunningDisparityErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunningDisparityErrorCount.proto_property, errs, need_convert)
    return self
end

function TRunningDisparityErrorCount:unpack(_)
    return self.RunningDisparityErrorCount
end

SASMetrics.RunningDisparityErrorCount = TRunningDisparityErrorCount

---@class SASMetrics.PhyResetProblemCount
---@field PhyResetProblemCount integer
local TPhyResetProblemCount = {}
TPhyResetProblemCount.__index = TPhyResetProblemCount
TPhyResetProblemCount.group = {}

local function TPhyResetProblemCount_from_obj(obj)
    return setmetatable(obj, TPhyResetProblemCount)
end

function TPhyResetProblemCount.new(PhyResetProblemCount)
    return TPhyResetProblemCount_from_obj({PhyResetProblemCount = PhyResetProblemCount})
end
---@param obj SASMetrics.PhyResetProblemCount
function TPhyResetProblemCount:init_from_obj(obj)
    self.PhyResetProblemCount = obj.PhyResetProblemCount
end

function TPhyResetProblemCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyResetProblemCount.group)
end

TPhyResetProblemCount.from_obj = TPhyResetProblemCount_from_obj

TPhyResetProblemCount.proto_property = {'PhyResetProblemCount'}

TPhyResetProblemCount.default = {0}

TPhyResetProblemCount.struct = {{name = 'PhyResetProblemCount', is_array = false, struct = nil}}

function TPhyResetProblemCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyResetProblemCount', self.PhyResetProblemCount, 'uint32', true, errs, need_convert)

    TPhyResetProblemCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyResetProblemCount.proto_property, errs, need_convert)
    return self
end

function TPhyResetProblemCount:unpack(_)
    return self.PhyResetProblemCount
end

SASMetrics.PhyResetProblemCount = TPhyResetProblemCount

---@class SASMetrics.LossDwordSyncCount
---@field LossDwordSyncCount integer
local TLossDwordSyncCount = {}
TLossDwordSyncCount.__index = TLossDwordSyncCount
TLossDwordSyncCount.group = {}

local function TLossDwordSyncCount_from_obj(obj)
    return setmetatable(obj, TLossDwordSyncCount)
end

function TLossDwordSyncCount.new(LossDwordSyncCount)
    return TLossDwordSyncCount_from_obj({LossDwordSyncCount = LossDwordSyncCount})
end
---@param obj SASMetrics.LossDwordSyncCount
function TLossDwordSyncCount:init_from_obj(obj)
    self.LossDwordSyncCount = obj.LossDwordSyncCount
end

function TLossDwordSyncCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLossDwordSyncCount.group)
end

TLossDwordSyncCount.from_obj = TLossDwordSyncCount_from_obj

TLossDwordSyncCount.proto_property = {'LossDwordSyncCount'}

TLossDwordSyncCount.default = {0}

TLossDwordSyncCount.struct = {{name = 'LossDwordSyncCount', is_array = false, struct = nil}}

function TLossDwordSyncCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LossDwordSyncCount', self.LossDwordSyncCount, 'uint32', true, errs, need_convert)

    TLossDwordSyncCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLossDwordSyncCount.proto_property, errs, need_convert)
    return self
end

function TLossDwordSyncCount:unpack(_)
    return self.LossDwordSyncCount
end

SASMetrics.LossDwordSyncCount = TLossDwordSyncCount

---@class SASMetrics.InvalidDwordCount
---@field InvalidDwordCount integer
local TInvalidDwordCount = {}
TInvalidDwordCount.__index = TInvalidDwordCount
TInvalidDwordCount.group = {}

local function TInvalidDwordCount_from_obj(obj)
    return setmetatable(obj, TInvalidDwordCount)
end

function TInvalidDwordCount.new(InvalidDwordCount)
    return TInvalidDwordCount_from_obj({InvalidDwordCount = InvalidDwordCount})
end
---@param obj SASMetrics.InvalidDwordCount
function TInvalidDwordCount:init_from_obj(obj)
    self.InvalidDwordCount = obj.InvalidDwordCount
end

function TInvalidDwordCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInvalidDwordCount.group)
end

TInvalidDwordCount.from_obj = TInvalidDwordCount_from_obj

TInvalidDwordCount.proto_property = {'InvalidDwordCount'}

TInvalidDwordCount.default = {0}

TInvalidDwordCount.struct = {{name = 'InvalidDwordCount', is_array = false, struct = nil}}

function TInvalidDwordCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InvalidDwordCount', self.InvalidDwordCount, 'uint32', true, errs, need_convert)

    TInvalidDwordCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInvalidDwordCount.proto_property, errs, need_convert)
    return self
end

function TInvalidDwordCount:unpack(_)
    return self.InvalidDwordCount
end

SASMetrics.InvalidDwordCount = TInvalidDwordCount

---@class SASMetrics.ControllerId
---@field ControllerId integer
local TControllerId = {}
TControllerId.__index = TControllerId
TControllerId.group = {}

local function TControllerId_from_obj(obj)
    return setmetatable(obj, TControllerId)
end

function TControllerId.new(ControllerId)
    return TControllerId_from_obj({ControllerId = ControllerId})
end
---@param obj SASMetrics.ControllerId
function TControllerId:init_from_obj(obj)
    self.ControllerId = obj.ControllerId
end

function TControllerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TControllerId.group)
end

TControllerId.from_obj = TControllerId_from_obj

TControllerId.proto_property = {'ControllerId'}

TControllerId.default = {0}

TControllerId.struct = {{name = 'ControllerId', is_array = false, struct = nil}}

function TControllerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', true, errs, need_convert)

    TControllerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TControllerId.proto_property, errs, need_convert)
    return self
end

function TControllerId:unpack(_)
    return self.ControllerId
end

SASMetrics.ControllerId = TControllerId

SASMetrics.interface = mdb.register_interface('bmc.kepler.Systems.Storage.SASMetrics', {
    ControllerId = {'y', nil, true, nil},
    InvalidDwordCount = {'u', nil, true, nil},
    LossDwordSyncCount = {'u', nil, true, nil},
    PhyResetProblemCount = {'u', nil, true, nil},
    RunningDisparityErrorCount = {'u', nil, true, nil}
}, {}, {})

return SASMetrics
