-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ReplicaDrive = {}

---@class ReplicaDrive.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj ReplicaDrive.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

ReplicaDrive.SerialNumber = TSerialNumber

---@class ReplicaDrive.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj ReplicaDrive.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

ReplicaDrive.Id = TId

ReplicaDrive.interface = mdb.register_interface('bmc.kepler.Systems.Storage.ReplicaDrive',
    {Id = {'y', nil, true, nil}, SerialNumber = {'s', nil, true, nil}}, {}, {})

return ReplicaDrive
