-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ReleaseStorageDrive = {}

---@class ReleaseStorageDrive.GetDriveDetailsReq
---@field DriveName string
local TGetDriveDetailsReq = {}
TGetDriveDetailsReq.__index = TGetDriveDetailsReq
TGetDriveDetailsReq.group = {}

local function TGetDriveDetailsReq_from_obj(obj)
    return setmetatable(obj, TGetDriveDetailsReq)
end

function TGetDriveDetailsReq.new(DriveName)
    return TGetDriveDetailsReq_from_obj({DriveName = DriveName})
end
---@param obj ReleaseStorageDrive.GetDriveDetailsReq
function TGetDriveDetailsReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
end

function TGetDriveDetailsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDriveDetailsReq.group)
end

TGetDriveDetailsReq.from_obj = TGetDriveDetailsReq_from_obj

TGetDriveDetailsReq.proto_property = {'DriveName'}

TGetDriveDetailsReq.default = {''}

TGetDriveDetailsReq.descriptions = {[=[The name of drive.]=]}

TGetDriveDetailsReq.struct = {{name = 'DriveName', is_array = false, struct = nil}}

function TGetDriveDetailsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriveName', self.DriveName, 'string', false, errs, need_convert)

    TGetDriveDetailsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDriveDetailsReq.proto_property, errs, need_convert)
    return self
end

function TGetDriveDetailsReq:unpack(_)
    return self.DriveName
end

ReleaseStorageDrive.GetDriveDetailsReq = TGetDriveDetailsReq

---@class ReleaseStorageDrive.Details
---@field key string
---@field value string
local TDetails = {}
TDetails.__index = TDetails
TDetails.group = {}

local function TDetails_from_obj(obj)
    return setmetatable(obj, TDetails)
end

function TDetails.new(dict)
    return TDetails_from_obj(dict)
end

---@param obj ReleaseStorageDrive.Details
function TDetails:init_from_obj(obj)
    self = obj
end

function TDetails:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDetails.group)
end

TDetails.from_obj = TDetails_from_obj

TDetails.proto_property = {}

TDetails.default = {}

TDetails.struct = {}

function TDetails:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TDetails:remove_error_props(errs, self)
    return self
end

function TDetails:unpack(_)
    return self
end

ReleaseStorageDrive.Details = TDetails

---@class ReleaseStorageDrive.DriveItem
---@field DriveInfo ReleaseStorageDrive.Details
local TDriveItem = {}
TDriveItem.__index = TDriveItem
TDriveItem.group = {}

local function TDriveItem_from_obj(obj)
    return setmetatable(obj, TDriveItem)
end

function TDriveItem.new(DriveInfo)
    return TDriveItem_from_obj({DriveInfo = DriveInfo})
end
---@param obj ReleaseStorageDrive.DriveItem
function TDriveItem:init_from_obj(obj)
    self.DriveInfo = obj.DriveInfo
end

function TDriveItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriveItem.group)
end

TDriveItem.from_obj = TDriveItem_from_obj

TDriveItem.proto_property = {'DriveInfo'}

TDriveItem.default = {ReleaseStorageDrive.Details.default}

TDriveItem.struct = {{name = 'DriveInfo', is_array = false, struct = ReleaseStorageDrive.Details.struct}}

function TDriveItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ReleaseStorageDrive.Details.new(self.DriveInfo):validate(prefix, errs, need_convert)

    TDriveItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriveItem.proto_property, errs, need_convert)
    return self
end

function TDriveItem:unpack(_)
    return self.DriveInfo
end

ReleaseStorageDrive.DriveItem = TDriveItem

---@class ReleaseStorageDrive.GetDriveDetailsRsp
---@field DriveInfos ReleaseStorageDrive.DriveItem[]
local TGetDriveDetailsRsp = {}
TGetDriveDetailsRsp.__index = TGetDriveDetailsRsp
TGetDriveDetailsRsp.group = {}

local function TGetDriveDetailsRsp_from_obj(obj)
    obj.DriveInfos = utils.from_obj(ReleaseStorageDrive.DriveItem, obj.DriveInfos, true)
    return setmetatable(obj, TGetDriveDetailsRsp)
end

function TGetDriveDetailsRsp.new(DriveInfos)
    return TGetDriveDetailsRsp_from_obj({DriveInfos = DriveInfos})
end
---@param obj ReleaseStorageDrive.GetDriveDetailsRsp
function TGetDriveDetailsRsp:init_from_obj(obj)
    self.DriveInfos = obj.DriveInfos
end

function TGetDriveDetailsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDriveDetailsRsp.group)
end

TGetDriveDetailsRsp.from_obj = TGetDriveDetailsRsp_from_obj

TGetDriveDetailsRsp.proto_property = {'DriveInfos'}

TGetDriveDetailsRsp.default = {{}}

TGetDriveDetailsRsp.struct = {{name = 'DriveInfos', is_array = true, struct = ReleaseStorageDrive.DriveItem.struct}}

function TGetDriveDetailsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.DriveInfos) do
        ReleaseStorageDrive.DriveItem.new(v.DriveInfo):validate(prefix, errs, need_convert)
    end

    TGetDriveDetailsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDriveDetailsRsp.proto_property, errs, need_convert)
    return self
end

function TGetDriveDetailsRsp:unpack(raw)
    return utils.unpack(raw, self.DriveInfos, true)
end

ReleaseStorageDrive.GetDriveDetailsRsp = TGetDriveDetailsRsp

ReleaseStorageDrive.interface = mdb.register_interface('bmc.kepler.Release.Storage.Drive', {}, {
    GetDriveDetails = {'a{ss}s', 'a(a{ss})', TGetDriveDetailsReq, TGetDriveDetailsRsp, [=[Get the drive details.]=]}
}, {})

return ReleaseStorageDrive
