-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Hardware = {}

---@class Hardware.UUID
---@field UUID string
local TUUID = {}
TUUID.__index = TUUID
TUUID.group = {}

local function TUUID_from_obj(obj)
    return setmetatable(obj, TUUID)
end

function TUUID.new(UUID)
    return TUUID_from_obj({UUID = UUID})
end
---@param obj Hardware.UUID
function TUUID:init_from_obj(obj)
    self.UUID = obj.UUID
end

function TUUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUUID.group)
end

TUUID.from_obj = TUUID_from_obj

TUUID.proto_property = {'UUID'}

TUUID.default = {''}

TUUID.struct = {{name = 'UUID', is_array = false, struct = nil}}

function TUUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UUID', self.UUID, 'string', true, errs, need_convert)

    TUUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUUID.proto_property, errs, need_convert)
    return self
end

function TUUID:unpack(_)
    return self.UUID
end

Hardware.UUID = TUUID

---@class Hardware.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Hardware.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Hardware.Model = TModel

---@class Hardware.Slot
---@field Slot string
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Hardware.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {''}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'string', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Hardware.Slot = TSlot

---@class Hardware.ManufactureDate
---@field ManufactureDate string
local TManufactureDate = {}
TManufactureDate.__index = TManufactureDate
TManufactureDate.group = {}

local function TManufactureDate_from_obj(obj)
    return setmetatable(obj, TManufactureDate)
end

function TManufactureDate.new(ManufactureDate)
    return TManufactureDate_from_obj({ManufactureDate = ManufactureDate})
end
---@param obj Hardware.ManufactureDate
function TManufactureDate:init_from_obj(obj)
    self.ManufactureDate = obj.ManufactureDate
end

function TManufactureDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufactureDate.group)
end

TManufactureDate.from_obj = TManufactureDate_from_obj

TManufactureDate.proto_property = {'ManufactureDate'}

TManufactureDate.default = {''}

TManufactureDate.struct = {{name = 'ManufactureDate', is_array = false, struct = nil}}

function TManufactureDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureDate', self.ManufactureDate, 'string', true, errs, need_convert)

    TManufactureDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufactureDate.proto_property, errs, need_convert)
    return self
end

function TManufactureDate:unpack(_)
    return self.ManufactureDate
end

Hardware.ManufactureDate = TManufactureDate

---@class Hardware.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Hardware.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Hardware.PartNumber = TPartNumber

---@class Hardware.AssetTag
---@field AssetTag string
local TAssetTag = {}
TAssetTag.__index = TAssetTag
TAssetTag.group = {}

local function TAssetTag_from_obj(obj)
    return setmetatable(obj, TAssetTag)
end

function TAssetTag.new(AssetTag)
    return TAssetTag_from_obj({AssetTag = AssetTag})
end
---@param obj Hardware.AssetTag
function TAssetTag:init_from_obj(obj)
    self.AssetTag = obj.AssetTag
end

function TAssetTag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssetTag.group)
end

TAssetTag.from_obj = TAssetTag_from_obj

TAssetTag.proto_property = {'AssetTag'}

TAssetTag.default = {''}

TAssetTag.struct = {{name = 'AssetTag', is_array = false, struct = nil}}

function TAssetTag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssetTag', self.AssetTag, 'string', true, errs, need_convert)

    TAssetTag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssetTag.proto_property, errs, need_convert)
    return self
end

function TAssetTag:unpack(_)
    return self.AssetTag
end

Hardware.AssetTag = TAssetTag

---@class Hardware.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Hardware.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Hardware.Manufacturer = TManufacturer

---@class Hardware.PCBVersion
---@field PCBVersion string
local TPCBVersion = {}
TPCBVersion.__index = TPCBVersion
TPCBVersion.group = {}

local function TPCBVersion_from_obj(obj)
    return setmetatable(obj, TPCBVersion)
end

function TPCBVersion.new(PCBVersion)
    return TPCBVersion_from_obj({PCBVersion = PCBVersion})
end
---@param obj Hardware.PCBVersion
function TPCBVersion:init_from_obj(obj)
    self.PCBVersion = obj.PCBVersion
end

function TPCBVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCBVersion.group)
end

TPCBVersion.from_obj = TPCBVersion_from_obj

TPCBVersion.proto_property = {'PCBVersion'}

TPCBVersion.default = {''}

TPCBVersion.struct = {{name = 'PCBVersion', is_array = false, struct = nil}}

function TPCBVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCBVersion', self.PCBVersion, 'string', true, errs, need_convert)

    TPCBVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCBVersion.proto_property, errs, need_convert)
    return self
end

function TPCBVersion:unpack(_)
    return self.PCBVersion
end

Hardware.PCBVersion = TPCBVersion

---@class Hardware.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj Hardware.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

Hardware.FirmwareVersion = TFirmwareVersion

---@class Hardware.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Hardware.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Hardware.SerialNumber = TSerialNumber

---@class Hardware.AssetName
---@field AssetName string
local TAssetName = {}
TAssetName.__index = TAssetName
TAssetName.group = {}

local function TAssetName_from_obj(obj)
    return setmetatable(obj, TAssetName)
end

function TAssetName.new(AssetName)
    return TAssetName_from_obj({AssetName = AssetName})
end
---@param obj Hardware.AssetName
function TAssetName:init_from_obj(obj)
    self.AssetName = obj.AssetName
end

function TAssetName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssetName.group)
end

TAssetName.from_obj = TAssetName_from_obj

TAssetName.proto_property = {'AssetName'}

TAssetName.default = {''}

TAssetName.struct = {{name = 'AssetName', is_array = false, struct = nil}}

function TAssetName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssetName', self.AssetName, 'string', true, errs, need_convert)

    TAssetName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssetName.proto_property, errs, need_convert)
    return self
end

function TAssetName:unpack(_)
    return self.AssetName
end

Hardware.AssetName = TAssetName

---@class Hardware.AssetType
---@field AssetType string
local TAssetType = {}
TAssetType.__index = TAssetType
TAssetType.group = {}

local function TAssetType_from_obj(obj)
    return setmetatable(obj, TAssetType)
end

function TAssetType.new(AssetType)
    return TAssetType_from_obj({AssetType = AssetType})
end
---@param obj Hardware.AssetType
function TAssetType:init_from_obj(obj)
    self.AssetType = obj.AssetType
end

function TAssetType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssetType.group)
end

TAssetType.from_obj = TAssetType_from_obj

TAssetType.proto_property = {'AssetType'}

TAssetType.default = {''}

TAssetType.struct = {{name = 'AssetType', is_array = false, struct = nil}}

function TAssetType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssetType', self.AssetType, 'string', true, errs, need_convert)

    TAssetType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssetType.proto_property, errs, need_convert)
    return self
end

function TAssetType:unpack(_)
    return self.AssetType
end

Hardware.AssetType = TAssetType

Hardware.interface = mdb.register_interface('bmc.kepler.Inventory.Hardware', {
    AssetType = {'s', nil, true, nil},
    AssetName = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    PCBVersion = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    AssetTag = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    ManufactureDate = {'s', nil, true, nil},
    Slot = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    UUID = {'s', nil, true, nil}
}, {}, {})

return Hardware
