-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DriveStatus = {}

---@class DriveStatus.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj DriveStatus.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

DriveStatus.Health = THealth

---@class DriveStatus.Failure
---@field Failure boolean
local TFailure = {}
TFailure.__index = TFailure
TFailure.group = {}

local function TFailure_from_obj(obj)
    return setmetatable(obj, TFailure)
end

function TFailure.new(Failure)
    return TFailure_from_obj({Failure = Failure})
end
---@param obj DriveStatus.Failure
function TFailure:init_from_obj(obj)
    self.Failure = obj.Failure
end

function TFailure:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFailure.group)
end

TFailure.from_obj = TFailure_from_obj

TFailure.proto_property = {'Failure'}

TFailure.default = {false}

TFailure.struct = {{name = 'Failure', is_array = false, struct = nil}}

function TFailure:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Failure', self.Failure, 'bool', true, errs, need_convert)

    TFailure:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFailure.proto_property, errs, need_convert)
    return self
end

function TFailure:unpack(_)
    return self.Failure
end

DriveStatus.Failure = TFailure

---@class DriveStatus.FirmwareStatusError
---@field FirmwareStatusError boolean
local TFirmwareStatusError = {}
TFirmwareStatusError.__index = TFirmwareStatusError
TFirmwareStatusError.group = {}

local function TFirmwareStatusError_from_obj(obj)
    return setmetatable(obj, TFirmwareStatusError)
end

function TFirmwareStatusError.new(FirmwareStatusError)
    return TFirmwareStatusError_from_obj({FirmwareStatusError = FirmwareStatusError})
end
---@param obj DriveStatus.FirmwareStatusError
function TFirmwareStatusError:init_from_obj(obj)
    self.FirmwareStatusError = obj.FirmwareStatusError
end

function TFirmwareStatusError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareStatusError.group)
end

TFirmwareStatusError.from_obj = TFirmwareStatusError_from_obj

TFirmwareStatusError.proto_property = {'FirmwareStatusError'}

TFirmwareStatusError.default = {false}

TFirmwareStatusError.struct = {{name = 'FirmwareStatusError', is_array = false, struct = nil}}

function TFirmwareStatusError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareStatusError', self.FirmwareStatusError, 'bool', true, errs, need_convert)

    TFirmwareStatusError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareStatusError.proto_property, errs, need_convert)
    return self
end

function TFirmwareStatusError:unpack(_)
    return self.FirmwareStatusError
end

DriveStatus.FirmwareStatusError = TFirmwareStatusError

---@class DriveStatus.CapacityError
---@field CapacityError boolean
local TCapacityError = {}
TCapacityError.__index = TCapacityError
TCapacityError.group = {}

local function TCapacityError_from_obj(obj)
    return setmetatable(obj, TCapacityError)
end

function TCapacityError.new(CapacityError)
    return TCapacityError_from_obj({CapacityError = CapacityError})
end
---@param obj DriveStatus.CapacityError
function TCapacityError:init_from_obj(obj)
    self.CapacityError = obj.CapacityError
end

function TCapacityError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapacityError.group)
end

TCapacityError.from_obj = TCapacityError_from_obj

TCapacityError.proto_property = {'CapacityError'}

TCapacityError.default = {false}

TCapacityError.struct = {{name = 'CapacityError', is_array = false, struct = nil}}

function TCapacityError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacityError', self.CapacityError, 'bool', true, errs, need_convert)

    TCapacityError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapacityError.proto_property, errs, need_convert)
    return self
end

function TCapacityError:unpack(_)
    return self.CapacityError
end

DriveStatus.CapacityError = TCapacityError

---@class DriveStatus.InAFailedArray
---@field InAFailedArray integer
local TInAFailedArray = {}
TInAFailedArray.__index = TInAFailedArray
TInAFailedArray.group = {}

local function TInAFailedArray_from_obj(obj)
    return setmetatable(obj, TInAFailedArray)
end

function TInAFailedArray.new(InAFailedArray)
    return TInAFailedArray_from_obj({InAFailedArray = InAFailedArray})
end
---@param obj DriveStatus.InAFailedArray
function TInAFailedArray:init_from_obj(obj)
    self.InAFailedArray = obj.InAFailedArray
end

function TInAFailedArray:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInAFailedArray.group)
end

TInAFailedArray.from_obj = TInAFailedArray_from_obj

TInAFailedArray.proto_property = {'InAFailedArray'}

TInAFailedArray.default = {0}

TInAFailedArray.struct = {{name = 'InAFailedArray', is_array = false, struct = nil}}

function TInAFailedArray:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InAFailedArray', self.InAFailedArray, 'uint8', true, errs, need_convert)

    TInAFailedArray:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInAFailedArray.proto_property, errs, need_convert)
    return self
end

function TInAFailedArray:unpack(_)
    return self.InAFailedArray
end

DriveStatus.InAFailedArray = TInAFailedArray

---@class DriveStatus.PredictiveFailure
---@field PredictiveFailure integer
local TPredictiveFailure = {}
TPredictiveFailure.__index = TPredictiveFailure
TPredictiveFailure.group = {}

local function TPredictiveFailure_from_obj(obj)
    return setmetatable(obj, TPredictiveFailure)
end

function TPredictiveFailure.new(PredictiveFailure)
    return TPredictiveFailure_from_obj({PredictiveFailure = PredictiveFailure})
end
---@param obj DriveStatus.PredictiveFailure
function TPredictiveFailure:init_from_obj(obj)
    self.PredictiveFailure = obj.PredictiveFailure
end

function TPredictiveFailure:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFailure.group)
end

TPredictiveFailure.from_obj = TPredictiveFailure_from_obj

TPredictiveFailure.proto_property = {'PredictiveFailure'}

TPredictiveFailure.default = {0}

TPredictiveFailure.struct = {{name = 'PredictiveFailure', is_array = false, struct = nil}}

function TPredictiveFailure:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFailure', self.PredictiveFailure, 'uint8', true, errs, need_convert)

    TPredictiveFailure:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFailure.proto_property, errs, need_convert)
    return self
end

function TPredictiveFailure:unpack(_)
    return self.PredictiveFailure
end

DriveStatus.PredictiveFailure = TPredictiveFailure

---@class DriveStatus.Missing
---@field Missing integer
local TMissing = {}
TMissing.__index = TMissing
TMissing.group = {}

local function TMissing_from_obj(obj)
    return setmetatable(obj, TMissing)
end

function TMissing.new(Missing)
    return TMissing_from_obj({Missing = Missing})
end
---@param obj DriveStatus.Missing
function TMissing:init_from_obj(obj)
    self.Missing = obj.Missing
end

function TMissing:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMissing.group)
end

TMissing.from_obj = TMissing_from_obj

TMissing.proto_property = {'Missing'}

TMissing.default = {0}

TMissing.struct = {{name = 'Missing', is_array = false, struct = nil}}

function TMissing:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Missing', self.Missing, 'uint16', true, errs, need_convert)

    TMissing:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMissing.proto_property, errs, need_convert)
    return self
end

function TMissing:unpack(_)
    return self.Missing
end

DriveStatus.Missing = TMissing

DriveStatus.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.DriveStatus', {
    Missing = {'q', nil, true, nil},
    PredictiveFailure = {'y', nil, true, nil},
    InAFailedArray = {'y', nil, true, nil},
    CapacityError = {'b', nil, true, nil},
    FirmwareStatusError = {'b', nil, true, nil},
    Failure = {'b', nil, true, nil},
    Health = {'y', nil, true, nil}
}, {}, {})

return DriveStatus
