-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DriveDiagnose = {}

---@class DriveDiagnose.GetDiagnoseDataReq
---@field DiagnoseDataType string[]
local TGetDiagnoseDataReq = {}
TGetDiagnoseDataReq.__index = TGetDiagnoseDataReq
TGetDiagnoseDataReq.group = {}

local function TGetDiagnoseDataReq_from_obj(obj)
    return setmetatable(obj, TGetDiagnoseDataReq)
end

function TGetDiagnoseDataReq.new(DiagnoseDataType)
    return TGetDiagnoseDataReq_from_obj({DiagnoseDataType = DiagnoseDataType})
end
---@param obj DriveDiagnose.GetDiagnoseDataReq
function TGetDiagnoseDataReq:init_from_obj(obj)
    self.DiagnoseDataType = obj.DiagnoseDataType
end

function TGetDiagnoseDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiagnoseDataReq.group)
end

TGetDiagnoseDataReq.from_obj = TGetDiagnoseDataReq_from_obj

TGetDiagnoseDataReq.proto_property = {'DiagnoseDataType'}

TGetDiagnoseDataReq.default = {{}}

TGetDiagnoseDataReq.struct = {{name = 'DiagnoseDataType', is_array = true, struct = nil}}

function TGetDiagnoseDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DiagnoseDataType', self.DiagnoseDataType, 'string', false, errs, need_convert)

    TGetDiagnoseDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiagnoseDataReq.proto_property, errs, need_convert)
    return self
end

function TGetDiagnoseDataReq:unpack(_)
    return self.DiagnoseDataType
end

DriveDiagnose.GetDiagnoseDataReq = TGetDiagnoseDataReq

---@class DriveDiagnose.CollectDiagnoseDataRsp
---@field TaskId integer
local TCollectDiagnoseDataRsp = {}
TCollectDiagnoseDataRsp.__index = TCollectDiagnoseDataRsp
TCollectDiagnoseDataRsp.group = {}

local function TCollectDiagnoseDataRsp_from_obj(obj)
    return setmetatable(obj, TCollectDiagnoseDataRsp)
end

function TCollectDiagnoseDataRsp.new(TaskId)
    return TCollectDiagnoseDataRsp_from_obj({TaskId = TaskId})
end
---@param obj DriveDiagnose.CollectDiagnoseDataRsp
function TCollectDiagnoseDataRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCollectDiagnoseDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectDiagnoseDataRsp.group)
end

TCollectDiagnoseDataRsp.from_obj = TCollectDiagnoseDataRsp_from_obj

TCollectDiagnoseDataRsp.proto_property = {'TaskId'}

TCollectDiagnoseDataRsp.default = {0}

TCollectDiagnoseDataRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCollectDiagnoseDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCollectDiagnoseDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectDiagnoseDataRsp.proto_property, errs, need_convert)
    return self
end

function TCollectDiagnoseDataRsp:unpack(_)
    return self.TaskId
end

DriveDiagnose.CollectDiagnoseDataRsp = TCollectDiagnoseDataRsp

---@class DriveDiagnose.CollectDiagnoseDataReq
---@field DiagnoseDataType string[]
local TCollectDiagnoseDataReq = {}
TCollectDiagnoseDataReq.__index = TCollectDiagnoseDataReq
TCollectDiagnoseDataReq.group = {}

local function TCollectDiagnoseDataReq_from_obj(obj)
    return setmetatable(obj, TCollectDiagnoseDataReq)
end

function TCollectDiagnoseDataReq.new(DiagnoseDataType)
    return TCollectDiagnoseDataReq_from_obj({DiagnoseDataType = DiagnoseDataType})
end
---@param obj DriveDiagnose.CollectDiagnoseDataReq
function TCollectDiagnoseDataReq:init_from_obj(obj)
    self.DiagnoseDataType = obj.DiagnoseDataType
end

function TCollectDiagnoseDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectDiagnoseDataReq.group)
end

TCollectDiagnoseDataReq.from_obj = TCollectDiagnoseDataReq_from_obj

TCollectDiagnoseDataReq.proto_property = {'DiagnoseDataType'}

TCollectDiagnoseDataReq.default = {{}}

TCollectDiagnoseDataReq.struct = {{name = 'DiagnoseDataType', is_array = true, struct = nil}}

function TCollectDiagnoseDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DiagnoseDataType', self.DiagnoseDataType, 'string', false, errs, need_convert)

    TCollectDiagnoseDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectDiagnoseDataReq.proto_property, errs, need_convert)
    return self
end

function TCollectDiagnoseDataReq:unpack(_)
    return self.DiagnoseDataType
end

DriveDiagnose.CollectDiagnoseDataReq = TCollectDiagnoseDataReq

---@class DriveDiagnose.Data
---@field key string
---@field value string
local TData = {}
TData.__index = TData
TData.group = {}

local function TData_from_obj(obj)
    return setmetatable(obj, TData)
end

function TData.new(dict)
    return TData_from_obj(dict)
end

---@param obj DriveDiagnose.Data
function TData:init_from_obj(obj)
    self = obj
end

function TData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TData.group)
end

TData.from_obj = TData_from_obj

TData.proto_property = {}

TData.default = {}

TData.struct = {}

function TData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TData:remove_error_props(errs, self)
    return self
end

function TData:unpack(_)
    return self
end

DriveDiagnose.Data = TData

---@class DriveDiagnose.GetDiagnoseDataRsp
---@field DiagnoseData DriveDiagnose.Data
local TGetDiagnoseDataRsp = {}
TGetDiagnoseDataRsp.__index = TGetDiagnoseDataRsp
TGetDiagnoseDataRsp.group = {}

local function TGetDiagnoseDataRsp_from_obj(obj)
    return setmetatable(obj, TGetDiagnoseDataRsp)
end

function TGetDiagnoseDataRsp.new(DiagnoseData)
    return TGetDiagnoseDataRsp_from_obj({DiagnoseData = DiagnoseData})
end
---@param obj DriveDiagnose.GetDiagnoseDataRsp
function TGetDiagnoseDataRsp:init_from_obj(obj)
    self.DiagnoseData = obj.DiagnoseData
end

function TGetDiagnoseDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiagnoseDataRsp.group)
end

TGetDiagnoseDataRsp.from_obj = TGetDiagnoseDataRsp_from_obj

TGetDiagnoseDataRsp.proto_property = {'DiagnoseData'}

TGetDiagnoseDataRsp.default = {DriveDiagnose.Data.default}

TGetDiagnoseDataRsp.struct = {{name = 'DiagnoseData', is_array = false, struct = DriveDiagnose.Data.struct}}

function TGetDiagnoseDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    DriveDiagnose.Data.new(self.DiagnoseData):validate(prefix, errs, need_convert)

    TGetDiagnoseDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiagnoseDataRsp.proto_property, errs, need_convert)
    return self
end

function TGetDiagnoseDataRsp:unpack(_)
    return self.DiagnoseData
end

DriveDiagnose.GetDiagnoseDataRsp = TGetDiagnoseDataRsp

DriveDiagnose.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.Diagnose', {}, {
    CollectDiagnoseData = {'a{ss}as', 'u', TCollectDiagnoseDataReq, TCollectDiagnoseDataRsp},
    GetDiagnoseData = {'a{ss}as', 'a{ss}', TGetDiagnoseDataReq, TGetDiagnoseDataRsp}
}, {})

return DriveDiagnose
