-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ControllerStatus = {}

---@class ControllerStatus.FaultCodeByBios
---@field FaultCodeByBios integer
local TFaultCodeByBios = {}
TFaultCodeByBios.__index = TFaultCodeByBios
TFaultCodeByBios.group = {}

local function TFaultCodeByBios_from_obj(obj)
    return setmetatable(obj, TFaultCodeByBios)
end

function TFaultCodeByBios.new(FaultCodeByBios)
    return TFaultCodeByBios_from_obj({FaultCodeByBios = FaultCodeByBios})
end
---@param obj ControllerStatus.FaultCodeByBios
function TFaultCodeByBios:init_from_obj(obj)
    self.FaultCodeByBios = obj.FaultCodeByBios
end

function TFaultCodeByBios:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultCodeByBios.group)
end

TFaultCodeByBios.from_obj = TFaultCodeByBios_from_obj

TFaultCodeByBios.proto_property = {'FaultCodeByBios'}

TFaultCodeByBios.default = {0}

TFaultCodeByBios.struct = {{name = 'FaultCodeByBios', is_array = false, struct = nil}}

function TFaultCodeByBios:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultCodeByBios', self.FaultCodeByBios, 'uint8', true, errs, need_convert)

    TFaultCodeByBios:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultCodeByBios.proto_property, errs, need_convert)
    return self
end

function TFaultCodeByBios:unpack(_)
    return self.FaultCodeByBios
end

ControllerStatus.FaultCodeByBios = TFaultCodeByBios

---@class ControllerStatus.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj ControllerStatus.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

ControllerStatus.Health = THealth

---@class ControllerStatus.CommunicationLoss
---@field CommunicationLoss integer
local TCommunicationLoss = {}
TCommunicationLoss.__index = TCommunicationLoss
TCommunicationLoss.group = {}

local function TCommunicationLoss_from_obj(obj)
    return setmetatable(obj, TCommunicationLoss)
end

function TCommunicationLoss.new(CommunicationLoss)
    return TCommunicationLoss_from_obj({CommunicationLoss = CommunicationLoss})
end
---@param obj ControllerStatus.CommunicationLoss
function TCommunicationLoss:init_from_obj(obj)
    self.CommunicationLoss = obj.CommunicationLoss
end

function TCommunicationLoss:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCommunicationLoss.group)
end

TCommunicationLoss.from_obj = TCommunicationLoss_from_obj

TCommunicationLoss.proto_property = {'CommunicationLoss'}

TCommunicationLoss.default = {0}

TCommunicationLoss.struct = {{name = 'CommunicationLoss', is_array = false, struct = nil}}

function TCommunicationLoss:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CommunicationLoss', self.CommunicationLoss, 'uint8', true, errs, need_convert)

    TCommunicationLoss:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCommunicationLoss.proto_property, errs, need_convert)
    return self
end

function TCommunicationLoss:unpack(_)
    return self.CommunicationLoss
end

ControllerStatus.CommunicationLoss = TCommunicationLoss

---@class ControllerStatus.FaultCode
---@field FaultCode integer
local TFaultCode = {}
TFaultCode.__index = TFaultCode
TFaultCode.group = {}

local function TFaultCode_from_obj(obj)
    return setmetatable(obj, TFaultCode)
end

function TFaultCode.new(FaultCode)
    return TFaultCode_from_obj({FaultCode = FaultCode})
end
---@param obj ControllerStatus.FaultCode
function TFaultCode:init_from_obj(obj)
    self.FaultCode = obj.FaultCode
end

function TFaultCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultCode.group)
end

TFaultCode.from_obj = TFaultCode_from_obj

TFaultCode.proto_property = {'FaultCode'}

TFaultCode.default = {0}

TFaultCode.struct = {{name = 'FaultCode', is_array = false, struct = nil}}

function TFaultCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultCode', self.FaultCode, 'uint16', true, errs, need_convert)

    TFaultCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultCode.proto_property, errs, need_convert)
    return self
end

function TFaultCode:unpack(_)
    return self.FaultCode
end

ControllerStatus.FaultCode = TFaultCode

ControllerStatus.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller.ControllerStatus', {
    FaultCode = {'q', nil, true, nil},
    CommunicationLoss = {'y', nil, true, nil},
    Health = {'y', nil, true, nil},
    FaultCodeByBios = {'y', nil, true, nil}
}, {}, {})

return ControllerStatus
