-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ConsistencyCheck = {}

---@class ConsistencyCheck.DelayToStart
---@field DelayToStart integer
local TDelayToStart = {}
TDelayToStart.__index = TDelayToStart
TDelayToStart.group = {}

local function TDelayToStart_from_obj(obj)
    return setmetatable(obj, TDelayToStart)
end

function TDelayToStart.new(DelayToStart)
    return TDelayToStart_from_obj({DelayToStart = DelayToStart})
end
---@param obj ConsistencyCheck.DelayToStart
function TDelayToStart:init_from_obj(obj)
    self.DelayToStart = obj.DelayToStart
end

function TDelayToStart:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDelayToStart.group)
end

TDelayToStart.from_obj = TDelayToStart_from_obj

TDelayToStart.proto_property = {'DelayToStart'}

TDelayToStart.default = {0}

TDelayToStart.struct = {{name = 'DelayToStart', is_array = false, struct = nil}}

function TDelayToStart:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DelayToStart', self.DelayToStart, 'uint32', true, errs, need_convert)

    TDelayToStart:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDelayToStart.proto_property, errs, need_convert)
    return self
end

function TDelayToStart:unpack(_)
    return self.DelayToStart
end

ConsistencyCheck.DelayToStart = TDelayToStart

---@class ConsistencyCheck.CompletedVolumeCounts
---@field CompletedVolumeCounts integer
local TCompletedVolumeCounts = {}
TCompletedVolumeCounts.__index = TCompletedVolumeCounts
TCompletedVolumeCounts.group = {}

local function TCompletedVolumeCounts_from_obj(obj)
    return setmetatable(obj, TCompletedVolumeCounts)
end

function TCompletedVolumeCounts.new(CompletedVolumeCounts)
    return TCompletedVolumeCounts_from_obj({CompletedVolumeCounts = CompletedVolumeCounts})
end
---@param obj ConsistencyCheck.CompletedVolumeCounts
function TCompletedVolumeCounts:init_from_obj(obj)
    self.CompletedVolumeCounts = obj.CompletedVolumeCounts
end

function TCompletedVolumeCounts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCompletedVolumeCounts.group)
end

TCompletedVolumeCounts.from_obj = TCompletedVolumeCounts_from_obj

TCompletedVolumeCounts.proto_property = {'CompletedVolumeCounts'}

TCompletedVolumeCounts.default = {0}

TCompletedVolumeCounts.struct = {{name = 'CompletedVolumeCounts', is_array = false, struct = nil}}

function TCompletedVolumeCounts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletedVolumeCounts', self.CompletedVolumeCounts, 'uint16', true, errs, need_convert)

    TCompletedVolumeCounts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCompletedVolumeCounts.proto_property, errs, need_convert)
    return self
end

function TCompletedVolumeCounts:unpack(_)
    return self.CompletedVolumeCounts
end

ConsistencyCheck.CompletedVolumeCounts = TCompletedVolumeCounts

---@class ConsistencyCheck.TotalVolumeCounts
---@field TotalVolumeCounts integer
local TTotalVolumeCounts = {}
TTotalVolumeCounts.__index = TTotalVolumeCounts
TTotalVolumeCounts.group = {}

local function TTotalVolumeCounts_from_obj(obj)
    return setmetatable(obj, TTotalVolumeCounts)
end

function TTotalVolumeCounts.new(TotalVolumeCounts)
    return TTotalVolumeCounts_from_obj({TotalVolumeCounts = TotalVolumeCounts})
end
---@param obj ConsistencyCheck.TotalVolumeCounts
function TTotalVolumeCounts:init_from_obj(obj)
    self.TotalVolumeCounts = obj.TotalVolumeCounts
end

function TTotalVolumeCounts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalVolumeCounts.group)
end

TTotalVolumeCounts.from_obj = TTotalVolumeCounts_from_obj

TTotalVolumeCounts.proto_property = {'TotalVolumeCounts'}

TTotalVolumeCounts.default = {0}

TTotalVolumeCounts.struct = {{name = 'TotalVolumeCounts', is_array = false, struct = nil}}

function TTotalVolumeCounts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalVolumeCounts', self.TotalVolumeCounts, 'uint16', true, errs, need_convert)

    TTotalVolumeCounts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalVolumeCounts.proto_property, errs, need_convert)
    return self
end

function TTotalVolumeCounts:unpack(_)
    return self.TotalVolumeCounts
end

ConsistencyCheck.TotalVolumeCounts = TTotalVolumeCounts

---@class ConsistencyCheck.RunningStatus
---@field RunningStatus string
local TRunningStatus = {}
TRunningStatus.__index = TRunningStatus
TRunningStatus.group = {}

local function TRunningStatus_from_obj(obj)
    return setmetatable(obj, TRunningStatus)
end

function TRunningStatus.new(RunningStatus)
    return TRunningStatus_from_obj({RunningStatus = RunningStatus})
end
---@param obj ConsistencyCheck.RunningStatus
function TRunningStatus:init_from_obj(obj)
    self.RunningStatus = obj.RunningStatus
end

function TRunningStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunningStatus.group)
end

TRunningStatus.from_obj = TRunningStatus_from_obj

TRunningStatus.proto_property = {'RunningStatus'}

TRunningStatus.default = {''}

TRunningStatus.struct = {{name = 'RunningStatus', is_array = false, struct = nil}}

function TRunningStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunningStatus', self.RunningStatus, 'string', true, errs, need_convert)

    TRunningStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunningStatus.proto_property, errs, need_convert)
    return self
end

function TRunningStatus:unpack(_)
    return self.RunningStatus
end

ConsistencyCheck.RunningStatus = TRunningStatus

---@class ConsistencyCheck.AutoRepairEnabled
---@field AutoRepairEnabled integer
local TAutoRepairEnabled = {}
TAutoRepairEnabled.__index = TAutoRepairEnabled
TAutoRepairEnabled.group = {}

local function TAutoRepairEnabled_from_obj(obj)
    return setmetatable(obj, TAutoRepairEnabled)
end

function TAutoRepairEnabled.new(AutoRepairEnabled)
    return TAutoRepairEnabled_from_obj({AutoRepairEnabled = AutoRepairEnabled})
end
---@param obj ConsistencyCheck.AutoRepairEnabled
function TAutoRepairEnabled:init_from_obj(obj)
    self.AutoRepairEnabled = obj.AutoRepairEnabled
end

function TAutoRepairEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoRepairEnabled.group)
end

TAutoRepairEnabled.from_obj = TAutoRepairEnabled_from_obj

TAutoRepairEnabled.proto_property = {'AutoRepairEnabled'}

TAutoRepairEnabled.default = {0}

TAutoRepairEnabled.struct = {{name = 'AutoRepairEnabled', is_array = false, struct = nil}}

function TAutoRepairEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoRepairEnabled', self.AutoRepairEnabled, 'uint8', true, errs, need_convert)

    TAutoRepairEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoRepairEnabled.proto_property, errs, need_convert)
    return self
end

function TAutoRepairEnabled:unpack(_)
    return self.AutoRepairEnabled
end

ConsistencyCheck.AutoRepairEnabled = TAutoRepairEnabled

---@class ConsistencyCheck.Rate
---@field Rate string
local TRate = {}
TRate.__index = TRate
TRate.group = {}

local function TRate_from_obj(obj)
    return setmetatable(obj, TRate)
end

function TRate.new(Rate)
    return TRate_from_obj({Rate = Rate})
end
---@param obj ConsistencyCheck.Rate
function TRate:init_from_obj(obj)
    self.Rate = obj.Rate
end

function TRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRate.group)
end

TRate.from_obj = TRate_from_obj

TRate.proto_property = {'Rate'}

TRate.default = {''}

TRate.struct = {{name = 'Rate', is_array = false, struct = nil}}

function TRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Rate', self.Rate, 'string', true, errs, need_convert)

    TRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRate.proto_property, errs, need_convert)
    return self
end

function TRate:unpack(_)
    return self.Rate
end

ConsistencyCheck.Rate = TRate

---@class ConsistencyCheck.PeriodOfHours
---@field PeriodOfHours integer
local TPeriodOfHours = {}
TPeriodOfHours.__index = TPeriodOfHours
TPeriodOfHours.group = {}

local function TPeriodOfHours_from_obj(obj)
    return setmetatable(obj, TPeriodOfHours)
end

function TPeriodOfHours.new(PeriodOfHours)
    return TPeriodOfHours_from_obj({PeriodOfHours = PeriodOfHours})
end
---@param obj ConsistencyCheck.PeriodOfHours
function TPeriodOfHours:init_from_obj(obj)
    self.PeriodOfHours = obj.PeriodOfHours
end

function TPeriodOfHours:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPeriodOfHours.group)
end

TPeriodOfHours.from_obj = TPeriodOfHours_from_obj

TPeriodOfHours.proto_property = {'PeriodOfHours'}

TPeriodOfHours.default = {0}

TPeriodOfHours.struct = {{name = 'PeriodOfHours', is_array = false, struct = nil}}

function TPeriodOfHours:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PeriodOfHours', self.PeriodOfHours, 'uint16', true, errs, need_convert)

    TPeriodOfHours:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPeriodOfHours.proto_property, errs, need_convert)
    return self
end

function TPeriodOfHours:unpack(_)
    return self.PeriodOfHours
end

ConsistencyCheck.PeriodOfHours = TPeriodOfHours

---@class ConsistencyCheck.State
---@field State integer
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State})
end
---@param obj ConsistencyCheck.State
function TState:init_from_obj(obj)
    self.State = obj.State
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {0}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', true, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

ConsistencyCheck.State = TState

---@class ConsistencyCheck.SetParametersRsp
local TSetParametersRsp = {}
TSetParametersRsp.__index = TSetParametersRsp
TSetParametersRsp.group = {}

local function TSetParametersRsp_from_obj(obj)
    return setmetatable(obj, TSetParametersRsp)
end

function TSetParametersRsp.new()
    return TSetParametersRsp_from_obj({})
end
---@param obj ConsistencyCheck.SetParametersRsp
function TSetParametersRsp:init_from_obj(obj)

end

function TSetParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetParametersRsp.group)
end

TSetParametersRsp.from_obj = TSetParametersRsp_from_obj

TSetParametersRsp.proto_property = {}

TSetParametersRsp.default = {}

TSetParametersRsp.struct = {}

function TSetParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetParametersRsp.proto_property, errs, need_convert)
    return self
end

function TSetParametersRsp:unpack(_)
end

ConsistencyCheck.SetParametersRsp = TSetParametersRsp

---@class ConsistencyCheck.SetParametersReq
---@field Period integer
---@field Rate integer
---@field AutoRepairedEnabled integer
local TSetParametersReq = {}
TSetParametersReq.__index = TSetParametersReq
TSetParametersReq.group = {}

local function TSetParametersReq_from_obj(obj)
    return setmetatable(obj, TSetParametersReq)
end

function TSetParametersReq.new(Period, Rate, AutoRepairedEnabled)
    return TSetParametersReq_from_obj({Period = Period, Rate = Rate, AutoRepairedEnabled = AutoRepairedEnabled})
end
---@param obj ConsistencyCheck.SetParametersReq
function TSetParametersReq:init_from_obj(obj)
    self.Period = obj.Period
    self.Rate = obj.Rate
    self.AutoRepairedEnabled = obj.AutoRepairedEnabled
end

function TSetParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetParametersReq.group)
end

TSetParametersReq.from_obj = TSetParametersReq_from_obj

TSetParametersReq.proto_property = {'Period', 'Rate', 'AutoRepairedEnabled'}

TSetParametersReq.default = {0, 0, 0}

TSetParametersReq.struct = {
    {name = 'Period', is_array = false, struct = nil}, {name = 'Rate', is_array = false, struct = nil},
    {name = 'AutoRepairedEnabled', is_array = false, struct = nil}
}

function TSetParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Period', self.Period, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Rate', self.Rate, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AutoRepairedEnabled', self.AutoRepairedEnabled, 'uint8', false, errs, need_convert)

    TSetParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetParametersReq.proto_property, errs, need_convert)
    return self
end

function TSetParametersReq:unpack(_)
    return self.Period, self.Rate, self.AutoRepairedEnabled
end

ConsistencyCheck.SetParametersReq = TSetParametersReq

---@class ConsistencyCheck.DisableRsp
local TDisableRsp = {}
TDisableRsp.__index = TDisableRsp
TDisableRsp.group = {}

local function TDisableRsp_from_obj(obj)
    return setmetatable(obj, TDisableRsp)
end

function TDisableRsp.new()
    return TDisableRsp_from_obj({})
end
---@param obj ConsistencyCheck.DisableRsp
function TDisableRsp:init_from_obj(obj)

end

function TDisableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisableRsp.group)
end

TDisableRsp.from_obj = TDisableRsp_from_obj

TDisableRsp.proto_property = {}

TDisableRsp.default = {}

TDisableRsp.struct = {}

function TDisableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisableRsp.proto_property, errs, need_convert)
    return self
end

function TDisableRsp:unpack(_)
end

ConsistencyCheck.DisableRsp = TDisableRsp

---@class ConsistencyCheck.DisableReq
local TDisableReq = {}
TDisableReq.__index = TDisableReq
TDisableReq.group = {}

local function TDisableReq_from_obj(obj)
    return setmetatable(obj, TDisableReq)
end

function TDisableReq.new()
    return TDisableReq_from_obj({})
end
---@param obj ConsistencyCheck.DisableReq
function TDisableReq:init_from_obj(obj)

end

function TDisableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisableReq.group)
end

TDisableReq.from_obj = TDisableReq_from_obj

TDisableReq.proto_property = {}

TDisableReq.default = {}

TDisableReq.struct = {}

function TDisableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisableReq.proto_property, errs, need_convert)
    return self
end

function TDisableReq:unpack(_)
end

ConsistencyCheck.DisableReq = TDisableReq

---@class ConsistencyCheck.EnableRsp
local TEnableRsp = {}
TEnableRsp.__index = TEnableRsp
TEnableRsp.group = {}

local function TEnableRsp_from_obj(obj)
    return setmetatable(obj, TEnableRsp)
end

function TEnableRsp.new()
    return TEnableRsp_from_obj({})
end
---@param obj ConsistencyCheck.EnableRsp
function TEnableRsp:init_from_obj(obj)

end

function TEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnableRsp.group)
end

TEnableRsp.from_obj = TEnableRsp_from_obj

TEnableRsp.proto_property = {}

TEnableRsp.default = {}

TEnableRsp.struct = {}

function TEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnableRsp.proto_property, errs, need_convert)
    return self
end

function TEnableRsp:unpack(_)
end

ConsistencyCheck.EnableRsp = TEnableRsp

---@class ConsistencyCheck.EnableReq
---@field Period integer
---@field Rate integer
---@field AutoRepairedEnabled integer
---@field DelayToStart integer
local TEnableReq = {}
TEnableReq.__index = TEnableReq
TEnableReq.group = {}

local function TEnableReq_from_obj(obj)
    return setmetatable(obj, TEnableReq)
end

function TEnableReq.new(Period, Rate, AutoRepairedEnabled, DelayToStart)
    return TEnableReq_from_obj({
        Period = Period,
        Rate = Rate,
        AutoRepairedEnabled = AutoRepairedEnabled,
        DelayToStart = DelayToStart
    })
end
---@param obj ConsistencyCheck.EnableReq
function TEnableReq:init_from_obj(obj)
    self.Period = obj.Period
    self.Rate = obj.Rate
    self.AutoRepairedEnabled = obj.AutoRepairedEnabled
    self.DelayToStart = obj.DelayToStart
end

function TEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnableReq.group)
end

TEnableReq.from_obj = TEnableReq_from_obj

TEnableReq.proto_property = {'Period', 'Rate', 'AutoRepairedEnabled', 'DelayToStart'}

TEnableReq.default = {0, 0, 0, 0}

TEnableReq.struct = {
    {name = 'Period', is_array = false, struct = nil}, {name = 'Rate', is_array = false, struct = nil},
    {name = 'AutoRepairedEnabled', is_array = false, struct = nil},
    {name = 'DelayToStart', is_array = false, struct = nil}
}

function TEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Period', self.Period, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Rate', self.Rate, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AutoRepairedEnabled', self.AutoRepairedEnabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelayToStart', self.DelayToStart, 'uint32', false, errs, need_convert)

    TEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnableReq.proto_property, errs, need_convert)
    return self
end

function TEnableReq:unpack(_)
    return self.Period, self.Rate, self.AutoRepairedEnabled, self.DelayToStart
end

ConsistencyCheck.EnableReq = TEnableReq

ConsistencyCheck.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller.ConsistencyCheck', {
    State = {'y', nil, true, nil},
    PeriodOfHours = {'q', nil, true, nil},
    Rate = {'s', nil, true, nil},
    AutoRepairEnabled = {'y', nil, true, nil},
    RunningStatus = {'s', nil, true, nil},
    TotalVolumeCounts = {'q', nil, true, nil},
    CompletedVolumeCounts = {'q', nil, true, nil},
    DelayToStart = {'u', nil, true, nil}
}, {
    Enable = {'a{ss}qyyu', '', TEnableReq, TEnableRsp},
    Disable = {'a{ss}', '', TDisableReq, TDisableRsp},
    SetParameters = {'a{ss}qyy', '', TSetParametersReq, TSetParametersRsp}
}, {})

return ConsistencyCheck
