-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Chip = {}

---@class Chip.ChipManufacturer
---@field ChipManufacturer string
local TChipManufacturer = {}
TChipManufacturer.__index = TChipManufacturer
TChipManufacturer.group = {}

local function TChipManufacturer_from_obj(obj)
    return setmetatable(obj, TChipManufacturer)
end

function TChipManufacturer.new(ChipManufacturer)
    return TChipManufacturer_from_obj({ChipManufacturer = ChipManufacturer})
end
---@param obj Chip.ChipManufacturer
function TChipManufacturer:init_from_obj(obj)
    self.ChipManufacturer = obj.ChipManufacturer
end

function TChipManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipManufacturer.group)
end

TChipManufacturer.from_obj = TChipManufacturer_from_obj

TChipManufacturer.proto_property = {'ChipManufacturer'}

TChipManufacturer.default = {''}

TChipManufacturer.struct = {{name = 'ChipManufacturer', is_array = false, struct = nil}}

function TChipManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipManufacturer', self.ChipManufacturer, 'string', true, errs, need_convert)

    TChipManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipManufacturer.proto_property, errs, need_convert)
    return self
end

function TChipManufacturer:unpack(_)
    return self.ChipManufacturer
end

Chip.ChipManufacturer = TChipManufacturer

---@class Chip.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Chip.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Chip.Model = TModel

Chip.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller.Chip',
    {Model = {'s', nil, true, nil}, ChipManufacturer = {'s', nil, true, nil}}, {}, {})

return Chip
