-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BatteryStatus = {}

---@class BatteryStatus.BatteryHealth
---@field BatteryHealth integer
local TBatteryHealth = {}
TBatteryHealth.__index = TBatteryHealth
TBatteryHealth.group = {}

local function TBatteryHealth_from_obj(obj)
    return setmetatable(obj, TBatteryHealth)
end

function TBatteryHealth.new(BatteryHealth)
    return TBatteryHealth_from_obj({BatteryHealth = BatteryHealth})
end
---@param obj BatteryStatus.BatteryHealth
function TBatteryHealth:init_from_obj(obj)
    self.BatteryHealth = obj.BatteryHealth
end

function TBatteryHealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBatteryHealth.group)
end

TBatteryHealth.from_obj = TBatteryHealth_from_obj

TBatteryHealth.proto_property = {'BatteryHealth'}

TBatteryHealth.default = {0}

TBatteryHealth.struct = {{name = 'BatteryHealth', is_array = false, struct = nil}}

function TBatteryHealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BatteryHealth', self.BatteryHealth, 'uint8', true, errs, need_convert)

    TBatteryHealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBatteryHealth.proto_property, errs, need_convert)
    return self
end

function TBatteryHealth:unpack(_)
    return self.BatteryHealth
end

BatteryStatus.BatteryHealth = TBatteryHealth

---@class BatteryStatus.BatteryFault
---@field BatteryFault integer
local TBatteryFault = {}
TBatteryFault.__index = TBatteryFault
TBatteryFault.group = {}

local function TBatteryFault_from_obj(obj)
    return setmetatable(obj, TBatteryFault)
end

function TBatteryFault.new(BatteryFault)
    return TBatteryFault_from_obj({BatteryFault = BatteryFault or 255})
end
---@param obj BatteryStatus.BatteryFault
function TBatteryFault:init_from_obj(obj)
    self.BatteryFault = obj.BatteryFault or 255
end

function TBatteryFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBatteryFault.group)
end

TBatteryFault.from_obj = TBatteryFault_from_obj

TBatteryFault.proto_property = {'BatteryFault'}

TBatteryFault.default = {0}

TBatteryFault.struct = {{name = 'BatteryFault', is_array = false, struct = nil}}

function TBatteryFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BatteryFault', self.BatteryFault, 'uint8', true, errs, need_convert)

    TBatteryFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBatteryFault.proto_property, errs, need_convert)
    return self
end

function TBatteryFault:unpack(_)
    return self.BatteryFault
end

BatteryStatus.BatteryFault = TBatteryFault

---@class BatteryStatus.BatteryPresence
---@field BatteryPresence integer
local TBatteryPresence = {}
TBatteryPresence.__index = TBatteryPresence
TBatteryPresence.group = {}

local function TBatteryPresence_from_obj(obj)
    return setmetatable(obj, TBatteryPresence)
end

function TBatteryPresence.new(BatteryPresence)
    return TBatteryPresence_from_obj({BatteryPresence = BatteryPresence or 255})
end
---@param obj BatteryStatus.BatteryPresence
function TBatteryPresence:init_from_obj(obj)
    self.BatteryPresence = obj.BatteryPresence or 255
end

function TBatteryPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBatteryPresence.group)
end

TBatteryPresence.from_obj = TBatteryPresence_from_obj

TBatteryPresence.proto_property = {'BatteryPresence'}

TBatteryPresence.default = {0}

TBatteryPresence.struct = {{name = 'BatteryPresence', is_array = false, struct = nil}}

function TBatteryPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BatteryPresence', self.BatteryPresence, 'uint8', true, errs, need_convert)

    TBatteryPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBatteryPresence.proto_property, errs, need_convert)
    return self
end

function TBatteryPresence:unpack(_)
    return self.BatteryPresence
end

BatteryStatus.BatteryPresence = TBatteryPresence

BatteryStatus.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller.BatteryStatus', {
    BatteryPresence = {'y', nil, true, 255},
    BatteryFault = {'y', nil, true, 255},
    BatteryHealth = {'y', nil, true, nil}
}, {}, {})

return BatteryStatus
