--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'storage.ipmi.ipmi_message'

local CT = enums.ChannelType

local StorageIpmiCmds = {}

StorageIpmiCmds.GetHddPlugCnt = {
    name = 'GetHddPlugCnt',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3A]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3A:1/unit:8, EventTyp]=] .. [=[e:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ HddBackPlaneNum:1/unit:8, Data/string>>]=],
    req = msg.GetHddPlugCntReq,
    rsp = msg.GetHddPlugCntRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetHddPwrStatus = {
    name = 'GetHddPwrStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,62]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x62:1/unit:8, HddLocat]=] ..
        [=[ion:1/unit:8, Reserve1:1/unit:8, HddID:1/unit:8, R]=] .. [=[eserve2:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetHddPwrStatusReq,
    rsp = msg.GetHddPwrStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerList = {
    name = 'GetControllerList',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,00,FF,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x00:1/unit:8, 0xFF:1/unit:8, 0xFF:1/uni]=] ..
        [=[t:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8, Readin]=] .. [=[gLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerListReq,
    rsp = msg.GetControllerListRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerFwVersion = {
    name = 'GetControllerFwVersion',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,01,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x01:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerFwVersionReq,
    rsp = msg.GetControllerFwVersionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerNvdataVersion = {
    name = 'GetControllerNvdataVersion',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,02,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x02:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerNvdataVersionReq,
    rsp = msg.GetControllerNvdataVersionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerInfo = {
    name = 'GetControllerInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,03,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x03:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerInfoReq,
    rsp = msg.GetControllerInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetLogicalDriveList = {
    name = 'GetLogicalDriveList',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,04,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x04:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetLogicalDriveListReq,
    rsp = msg.GetLogicalDriveListRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetCachecadeAssociatedLds = {
    name = 'GetCachecadeAssociatedLds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,06,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x06:1/unit:8, ControllerId:1/unit:8, Ca]=] ..
        [=[checadeID:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2]=] .. [=[/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetCachecadeAssociatedLdsReq,
    rsp = msg.GetCachecadeAssociatedLdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetLogicalDrivePds = {
    name = 'GetLogicalDrivePds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,07,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x07:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/un]=] .. [=[it:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetLogicalDrivePdsReq,
    rsp = msg.GetLogicalDrivePdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerPds = {
    name = 'GetControllerPds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,08,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x08:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerPdsReq,
    rsp = msg.GetControllerPdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetPhysicalDriveLocation = {
    name = 'GetPhysicalDriveLocation',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,09,FF,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x09:1/unit:8, 0xFF:1/unit:8, PhysicalDr]=] ..
        [=[iveID:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/uni]=] .. [=[t:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetPhysicalDriveLocationReq,
    rsp = msg.GetPhysicalDriveLocationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetPhysicalDriveInfo = {
    name = 'GetPhysicalDriveInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0A,FF,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0A:1/unit:8, 0xFF:1/unit:8, PhysicalDr]=] ..
        [=[iveID:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/uni]=] .. [=[t:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetPhysicalDriveInfoReq,
    rsp = msg.GetPhysicalDriveInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetPhysicalDriveLedStatus = {
    name = 'GetPhysicalDriveLedStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,12,FF,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x12:1/unit:8, 0xFF:1/unit:8, PhysicalDr]=] ..
        [=[iveID:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/uni]=] .. [=[t:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetPhysicalDriveLedStatusReq,
    rsp = msg.GetPhysicalDriveLedStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetArrayList = {
    name = 'GetArrayList',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0B,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0B:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetArrayListReq,
    rsp = msg.GetArrayListRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetArrayInfo = {
    name = 'GetArrayInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0C]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0C:1/unit:8, ControllerId:1/unit:8, Ar]=] ..
        [=[rayIDLow:1/unit:8, ArrayIDHigh:1/unit:8, ReadingOf]=] .. [=[fset:2/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetArrayInfoReq,
    rsp = msg.GetArrayInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetArrayLds = {
    name = 'GetArrayLds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0D]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0D:1/unit:8, ControllerId:1/unit:8, Ar]=] ..
        [=[rayIDLow:1/unit:8, ArrayIDHigh:1/unit:8, ReadingOf]=] .. [=[fset:2/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetArrayLdsReq,
    rsp = msg.GetArrayLdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetArrayPds = {
    name = 'GetArrayPds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0E]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0E:1/unit:8, ControllerId:1/unit:8, Ar]=] ..
        [=[rayIDLow:1/unit:8, ArrayIDHigh:1/unit:8, ReadingOf]=] .. [=[fset:2/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetArrayPdsReq,
    rsp = msg.GetArrayPdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetLdDedicatedSparedPds = {
    name = 'GetLdDedicatedSparedPds',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,0F,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0F:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/un]=] .. [=[it:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetLdDedicatedSparedPdsReq,
    rsp = msg.GetLdDedicatedSparedPdsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetControllerCapability = {
    name = 'GetControllerCapability',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,11,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x11:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetControllerCapabilityReq,
    rsp = msg.GetControllerCapabilityRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetLogicalDriveListEx = {
    name = 'GetLogicalDriveListEx',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,13,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x13:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8]=] .. [=[, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetLogicalDriveListExReq,
    rsp = msg.GetLogicalDriveListExRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetCachecadeAssociatedLdsEx = {
    name = 'GetCachecadeAssociatedLdsEx',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,14,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x14:1/unit:8, ControllerId:1/unit:8, Ca]=] ..
        [=[checadeID:1/unit:8, 0xFF:1/unit:8, ReadingOffset:2]=] .. [=[/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetCachecadeAssociatedLdsExReq,
    rsp = msg.GetCachecadeAssociatedLdsExRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetArrayLdsEx = {
    name = 'GetArrayLdsEx',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,15]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x15:1/unit:8, ControllerId:1/unit:8, Ar]=] ..
        [=[rayIDLow:1/unit:8, ArrayIDHigh:1/unit:8, ReadingOf]=] .. [=[fset:2/unit:8, ReadingLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:1/unit:8, Data/string>>]=],
    req = msg.GetArrayLdsExReq,
    rsp = msg.GetArrayLdsExRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.CreateLogicalDriveOnNewArray = {
    name = 'CreateLogicalDriveOnNewArray',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,01,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x01:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.CreateLogicalDriveOnNewArrayReq,
    rsp = msg.CreateLogicalDriveOnNewArrayRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.CreateCachecadeLogicalDrive = {
    name = 'CreateCachecadeLogicalDrive',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,02,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x02:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.CreateCachecadeLogicalDriveReq,
    rsp = msg.CreateCachecadeLogicalDriveRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.CreateLogicalDriveOnExistedArray = {
    name = 'CreateLogicalDriveOnExistedArray',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,03]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x03:1/unit:8, ControllerId:1/unit:8, Ar]=] ..
        [=[rayIDLow:1/unit:8, ArrayIDHigh:1/unit:8, Frame:1/u]=] ..
        [=[nit:8, WritingOffset:2/unit:8, WritingLength:1/uni]=] .. [=[t:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.CreateLogicalDriveOnExistedArrayReq,
    rsp = msg.CreateLogicalDriveOnExistedArrayRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.DeleteLogicalDrive = {
    name = 'DeleteLogicalDrive',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,04,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x04:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.DeleteLogicalDriveReq,
    rsp = msg.DeleteLogicalDriveRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveName = {
    name = 'SetLogicalDriveName',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,05,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x05:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveNameReq,
    rsp = msg.SetLogicalDriveNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicDriveRp = {
    name = 'SetLogicDriveRp',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,06,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x06:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicDriveRpReq,
    rsp = msg.SetLogicDriveRpRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicDriveWp = {
    name = 'SetLogicDriveWp',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,07,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x07:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicDriveWpReq,
    rsp = msg.SetLogicDriveWpRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveIOP = {
    name = 'SetLogicalDriveIOP',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,08,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x08:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveIOPReq,
    rsp = msg.SetLogicalDriveIOPRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveAP = {
    name = 'SetLogicalDriveAP',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,09,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x09:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveAPReq,
    rsp = msg.SetLogicalDriveAPRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveDCP = {
    name = 'SetLogicalDriveDCP',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0A,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0A:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveDCPReq,
    rsp = msg.SetLogicalDriveDCPRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveBGI = {
    name = 'SetLogicalDriveBGI',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0B,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0B:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveBGIReq,
    rsp = msg.SetLogicalDriveBGIRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicalDriveCachecade = {
    name = 'SetLogicalDriveCachecade',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0C,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0C:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicalDriveCachecadeReq,
    rsp = msg.SetLogicalDriveCachecadeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogicDriveBootable = {
    name = 'SetLogicDriveBootable',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0D,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0D:1/unit:8, ControllerId:1/unit:8, Vo]=] ..
        [=[lumeId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wr]=] ..
        [=[itingOffset:2/unit:8, WritingLength:1/unit:8, Data]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLogicDriveBootableReq,
    rsp = msg.SetLogicDriveBootableRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetControllerCopyback = {
    name = 'SetControllerCopyback',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0E,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0E:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetControllerCopybackReq,
    rsp = msg.SetControllerCopybackRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetControllerSmarterCopyback = {
    name = 'SetControllerSmarterCopyback',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,0F,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x0F:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetControllerSmarterCopybackReq,
    rsp = msg.SetControllerSmarterCopybackRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetControllerRestoreSettings = {
    name = 'SetControllerRestoreSettings',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,10,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x10:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetControllerRestoreSettingsReq,
    rsp = msg.SetControllerRestoreSettingsRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetControllerJbod = {
    name = 'SetControllerJbod',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,11,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x11:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetControllerJbodReq,
    rsp = msg.SetControllerJbodRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetHotspareType = {
    name = 'SetHotspareType',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,12,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x12:1/unit:8, ControllerId:1/unit:8, Dr]=] ..
        [=[iveId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wri]=] ..
        [=[tingOffset:2/unit:8, WritingLength:1/unit:8, Data/]=] .. [=[string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetHotspareTypeReq,
    rsp = msg.SetHotspareTypeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetFirmwareStatus = {
    name = 'SetFirmwareStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,13,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x13:1/unit:8, ControllerId:1/unit:8, Dr]=] ..
        [=[iveId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wri]=] ..
        [=[tingOffset:2/unit:8, WritingLength:1/unit:8, Data/]=] .. [=[string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetFirmwareStatusReq,
    rsp = msg.SetFirmwareStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLocationIndicatorState = {
    name = 'SetLocationIndicatorState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,14,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x14:1/unit:8, ControllerId:1/unit:8, Dr]=] ..
        [=[iveId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wri]=] ..
        [=[tingOffset:2/unit:8, WritingLength:1/unit:8, Data/]=] .. [=[string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetLocationIndicatorStateReq,
    rsp = msg.SetLocationIndicatorStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetControllerOutofband = {
    name = 'SetControllerOutofband',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,15,*,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x15:1/unit:8, ControllerId:1/unit:8, 0x]=] ..
        [=[FF:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Writin]=] ..
        [=[gOffset:2/unit:8, WritingLength:1/unit:8, Data/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8, Data/string>>]=],
    req = msg.SetControllerOutofbandReq,
    rsp = msg.SetControllerOutofbandRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetFaultIndicatorState = {
    name = 'SetFaultIndicatorState',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,18,*,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x18:1/unit:8, ControllerId:1/unit:8, Dr]=] ..
        [=[iveId:1/unit:8, 0xFF:1/unit:8, Frame:1/unit:8, Wri]=] ..
        [=[tingOffset:2/unit:8, WritingLength:1/unit:8, Data:]=] .. [=[WritingLength/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reserve:4/unit:8>>]=],
    req = msg.SetFaultIndicatorStateReq,
    rsp = msg.SetFaultIndicatorStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetDiskSilk = {
    name = 'GetDiskSilk',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,02]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x02:1/u]=] ..
        [=[nit:8, Type:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetDiskSilkReq,
    rsp = msg.GetDiskSilkRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetRaidControllerTemp = {
    name = 'GetRaidControllerTemp',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,01,05]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x31:1/unit:8, 0x01:1/u]=] .. [=[nit:8, 0x05:1/unit:8, Device:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, Unit:1/unit:8>>]=],
    req = msg.GetRaidControllerTempReq,
    rsp = msg.GetRaidControllerTempRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetRaidFaultStatus = {
    name = 'SetRaidFaultStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,0E]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x05:1/unit:8, 0x0E:1/u]=] ..
        [=[nit:8, EventDirection:1/unit:8, DeviceStatus1:1/un]=] ..
        [=[it:8, Bus:1/unit:8, Device:1/unit:8, Function:1/un]=] .. [=[it:8, ErrorCode:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetRaidFaultStatusReq,
    rsp = msg.SetRaidFaultStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetDiskManufacturer = {
    name = 'GetDiskManufacturer',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,02,*,63]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x02:1/un]=] ..
        [=[it:8, DeviceNumber:1/unit:8, 0x63:1/unit:8, ReadOf]=] .. [=[fset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetDiskManufacturerReq,
    rsp = msg.GetDiskManufacturerRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetPdLogCollect = {
    name = 'SetPdLogCollect',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,18]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] .. [=[1/unit:8, 0x18:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetPdLogCollectReq,
    rsp = msg.SetPdLogCollectRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetPCHDiskInfo = {
    name = 'SetPCHDiskInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[CE]=],
    decode = [=[<<0xCE:1/unit:8, DiskType:1/unit:8, SlotNumber:1/u]=] ..
        [=[nit:8, InterfaceType:1/unit:8, FirmwareVersionLen:]=] ..
        [=[1/unit:8, FirmwareVersion:8/string, Reserve:4/stri]=] ..
        [=[ng, CapacityMB:4/unit:8, ModelLen:1/unit:8, Model:]=] ..
        [=[40/string, SNLen:1/unit:8, SN:20/string, Reserve1:]=] ..
        [=[12/string, MediaType:1/unit:8, NegotitatedspeedGbs]=] ..
        [=[:8/unit:8, CapableSpeedGbs:8/unit:8, ManufacturerL]=] .. [=[en:1/unit:8, Manufacturer:32/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPCHDiskInfoReq,
    rsp = msg.SetPCHDiskInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.SetLogAutoCollectConfig = {
    name = 'SetLogAutoCollectConfig',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,19,FF,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x19:1/unit:8, 0xFF:1/unit:8, 0xFF:1/uni]=] ..
        [=[t:8, 0xFF:1/unit:8, Frame:1/unit:8, WritingOffset:]=] ..
        [=[2/unit:8, WritingLength:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetLogAutoCollectConfigReq,
    rsp = msg.SetLogAutoCollectConfigRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.GetLogAutoCollectConfig = {
    name = 'GetLogAutoCollectConfig',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3D,*,19,FF,FF,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3D:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x19:1/unit:8, 0xFF:1/unit:8, 0xFF:1/uni]=] ..
        [=[t:8, 0xFF:1/unit:8, ReadingOffset:2/unit:8, Readin]=] .. [=[gLength:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ Reserve:1/unit:8, LogAutoCollectEnable:1/unit:8, ]=] .. [=[LogAutoCollectInterval:1/unit:8>>]=],
    req = msg.GetLogAutoCollectConfigReq,
    rsp = msg.GetLogAutoCollectConfigRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

StorageIpmiCmds.StartDriveCollectLog = {
    name = 'StartDriveCollectLog',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3E,*,1A,FF,*,FF]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x3E:1/unit:8, Reserve:]=] ..
        [=[1/unit:8, 0x1A:1/unit:8, 0xFF:1/unit:8, DriveId:1/]=] ..
        [=[unit:8, 0xFF:1/unit:8, Frame:1/unit:8, WritingOffs]=] ..
        [=[et:2/unit:8, WritingLength:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.StartDriveCollectLogReq,
    rsp = msg.StartDriveCollectLogRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

return StorageIpmiCmds
