--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogicalDriveIOP = {}

---@class StorageIpmiCmds.SetLogicalDriveIOPReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogicalDriveIOPReq = {}
TSetLogicalDriveIOPReq.__index = TSetLogicalDriveIOPReq
TSetLogicalDriveIOPReq.group = {}

local function TSetLogicalDriveIOPReq_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveIOPReq)
end

function TSetLogicalDriveIOPReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetLogicalDriveIOPReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveIOPReq
function TSetLogicalDriveIOPReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogicalDriveIOPReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveIOPReq.group)
end

TSetLogicalDriveIOPReq.from_obj = TSetLogicalDriveIOPReq_from_obj

TSetLogicalDriveIOPReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogicalDriveIOPReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLogicalDriveIOPReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveIOPReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveIOPReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveIOPReq.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveIOPReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLogicalDriveIOP.SetLogicalDriveIOPReq = TSetLogicalDriveIOPReq

---@class StorageIpmiCmds.SetLogicalDriveIOPRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLogicalDriveIOPRsp = {}
TSetLogicalDriveIOPRsp.__index = TSetLogicalDriveIOPRsp
TSetLogicalDriveIOPRsp.group = {}

local function TSetLogicalDriveIOPRsp_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveIOPRsp)
end

function TSetLogicalDriveIOPRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLogicalDriveIOPRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveIOPRsp
function TSetLogicalDriveIOPRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLogicalDriveIOPRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveIOPRsp.group)
end

TSetLogicalDriveIOPRsp.from_obj = TSetLogicalDriveIOPRsp_from_obj

TSetLogicalDriveIOPRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLogicalDriveIOPRsp.default = {0, 0, 0, ''}

TSetLogicalDriveIOPRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveIOPRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveIOPRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveIOPRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveIOPRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLogicalDriveIOP.SetLogicalDriveIOPRsp = TSetLogicalDriveIOPRsp

return SetLogicalDriveIOP
