--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogAutoCollectConfig = {}

---@class StorageIpmiCmds.SetLogAutoCollectConfigReq
---@field ManufacturerId integer
---@field Reserve integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogAutoCollectConfigReq = {}
TSetLogAutoCollectConfigReq.__index = TSetLogAutoCollectConfigReq
TSetLogAutoCollectConfigReq.group = {}

local function TSetLogAutoCollectConfigReq_from_obj(obj)
    return setmetatable(obj, TSetLogAutoCollectConfigReq)
end

function TSetLogAutoCollectConfigReq.new(ManufacturerId, Reserve, Frame, WritingOffset, WritingLength, Data)
    return TSetLogAutoCollectConfigReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogAutoCollectConfigReq
function TSetLogAutoCollectConfigReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogAutoCollectConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogAutoCollectConfigReq.group)
end

TSetLogAutoCollectConfigReq.from_obj = TSetLogAutoCollectConfigReq_from_obj

TSetLogAutoCollectConfigReq.proto_property = {
    'ManufacturerId', 'Reserve', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogAutoCollectConfigReq.default = {0, 0, 0, 0, 0, ''}

TSetLogAutoCollectConfigReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogAutoCollectConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogAutoCollectConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogAutoCollectConfigReq.proto_property, errs, need_convert)
    return self
end

function TSetLogAutoCollectConfigReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.Frame, self.WritingOffset, self.WritingLength, self.Data
end

SetLogAutoCollectConfig.SetLogAutoCollectConfigReq = TSetLogAutoCollectConfigReq

---@class StorageIpmiCmds.SetLogAutoCollectConfigRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetLogAutoCollectConfigRsp = {}
TSetLogAutoCollectConfigRsp.__index = TSetLogAutoCollectConfigRsp
TSetLogAutoCollectConfigRsp.group = {}

local function TSetLogAutoCollectConfigRsp_from_obj(obj)
    return setmetatable(obj, TSetLogAutoCollectConfigRsp)
end

function TSetLogAutoCollectConfigRsp.new(CompletionCode, ManufactureId)
    return TSetLogAutoCollectConfigRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj StorageIpmiCmds.SetLogAutoCollectConfigRsp
function TSetLogAutoCollectConfigRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetLogAutoCollectConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogAutoCollectConfigRsp.group)
end

TSetLogAutoCollectConfigRsp.from_obj = TSetLogAutoCollectConfigRsp_from_obj

TSetLogAutoCollectConfigRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetLogAutoCollectConfigRsp.default = {0, 0}

TSetLogAutoCollectConfigRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetLogAutoCollectConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetLogAutoCollectConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogAutoCollectConfigRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogAutoCollectConfigRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetLogAutoCollectConfig.SetLogAutoCollectConfigRsp = TSetLogAutoCollectConfigRsp

return SetLogAutoCollectConfig
